/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.cancelReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.regex.Matcher;

public class CheckAirlineLocatorProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (!((SabreGdsAccount)gdsAccountCtr.getEntity()).isDoNotCancelReservationsWithNoAirlineLocator()) {
            return;
        }
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        boolean hasMissingAirlineLocators = false;
        for (AirType air : GetReservationHelper.getAirs(response)) {
            Matcher airlineLocatorMatcher = GetReservationHelper.PATTERN_SUPPLIER_REF.matcher(air.getAirlineRefId());
            if (airlineLocatorMatcher.matches()) continue;
            hasMissingAirlineLocators = true;
            break;
        }
        if (hasMissingAirlineLocators) {
            throw Xeption.forEndUser((String)"CANCEL_IMPOSSIBLE_NO_AIRLINE_LOCATOR", (Object[])new Object[0]);
        }
    }
}

