/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.cancelReservation;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WETRCommandResponseParser
extends BaseProcessor {
    private static final List<String> COUPON_CANCEL_STATUSES = Arrays.asList("RFND", "VOID");
    private static final List<String> COUPON_STATUSES = Arrays.asList("OPEN", "USED", "VOID", "PRTD", "EXCH", "RFND", "CKIN", "CTRL", "ACTL", "SUSP", "OK", "REAC", "****");

    public void process(MessageContext ctx) throws Exception {
        String commandResponse = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        if (commandResponse.isEmpty()) {
            throw Xeption.forDeveloper((String)"WETR command response is empty", (Object[])new Object[0]);
        }
        Iterator<String> linesIter = Arrays.asList(commandResponse.split(System.lineSeparator())).iterator();
        while (linesIter.hasNext()) {
            String[] lineElements = linesIter.next().split("\\s+");
            int statElementNumber = -1;
            for (int i = 0; i < lineElements.length; ++i) {
                if (!"STAT".equals(lineElements[i])) continue;
                statElementNumber = i;
                break;
            }
            if (statElementNumber != -1) {
                String status = linesIter.next().split("\\s+")[statElementNumber];
                if (!COUPON_STATUSES.contains(status)) {
                    throw Xeption.forDeveloper((String)("unknown coupon status " + status), (Object[])new Object[0]);
                }
                if (!COUPON_CANCEL_STATUSES.contains(status)) {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.HAS_INAPPROPRIATE_COUPON_STATUS, (Object)Boolean.TRUE);
                }
                return;
            }
            if (linesIter.hasNext()) continue;
            throw Xeption.forDeveloper((String)("coupon status not found in WETR command response:\n" + commandResponse), (Object[])new Object[0]);
        }
    }
}

