/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.complementBooking.carbonEmissions;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.triprecord.BaseTripAttributes;
import com.sabre.webservices.triprecord.CarbonCalculatorRQ;
import java.util.ArrayList;
import java.util.Map;

public class CarbonCalculatorRequestBuilder
extends BaseProcessor {
    private boolean tryDifferentCodes;

    public void configure(Map<String, String> parameters) {
        this.tryDifferentCodes = Boolean.parseBoolean(parameters.get("try-different-codes"));
    }

    public void process(MessageContext ctx) {
        MiscUtil.Pair segmentAndProduct = (MiscUtil.Pair)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.SEGMENT_AND_PRODUCT);
        Segment segment = (Segment)segmentAndProduct.getFirst();
        CarbonCalculatorRQ request = new CarbonCalculatorRQ();
        ArrayList<CarbonCalculatorRQ.Segment> segmentList = new ArrayList<CarbonCalculatorRQ.Segment>();
        CarbonCalculatorRQ.Segment cs = new CarbonCalculatorRQ.Segment();
        CarbonCalculatorRQ.Segment.Flight csf = new CarbonCalculatorRQ.Segment.Flight();
        csf.setDepartureAirport(this.getAirportCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        csf.setArrivalAirport(this.getAirportCode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        csf.setAirlineCode(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
        csf.setEquipmentType(SabreHelper.getNativeCode((DictionaryReference)segment.getBoard()));
        cs.setFlight(csf);
        segmentList.add(cs);
        request.setSegmentList(segmentList);
        BaseTripAttributes baseTripAttributes = new BaseTripAttributes();
        baseTripAttributes.setVersion("1.3.0");
        request.setBaseTripAttributes(baseTripAttributes);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"Carbon_CalculatorRQ");
    }

    private String getAirportCode(DictionaryReference<GeoLocation> location) {
        String code = SabreHelper.getNativeCode(location);
        if (this.tryDifferentCodes) {
            // empty if block
        }
        return code;
    }
}

