/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.complementBooking.carbonEmissions;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CarbonEmissionsCache {
    private static final String IBUS_CONTEXT_KEY = CarbonEmissionsCache.class.getName();
    private final Map<List<String>, Integer> data = new HashMap<List<String>, Integer>();

    CarbonEmissionsCache() {
    }

    static CarbonEmissionsCache get(MessageContext ctx) {
        CarbonEmissionsCache cache = (CarbonEmissionsCache)ctx.getObject(IBUS_CONTEXT_KEY);
        if (cache == null) {
            cache = new CarbonEmissionsCache();
            ctx.putObject(IBUS_CONTEXT_KEY, (Object)cache);
        }
        return cache;
    }

    private static List<String> buildKey(Segment segment) {
        return Stream.of(segment.getDepartureLocation(), segment.getArriveLocation(), segment.getAirline(), segment.getBoard()).map(SabreHelper::getNativeCode).collect(Collectors.toList());
    }

    Integer getValue(Segment segment) {
        return this.data.get(CarbonEmissionsCache.buildKey(segment));
    }

    void setValue(Segment segment, Integer value) {
        this.data.put(CarbonEmissionsCache.buildKey(segment), value);
    }
}

