/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.complementBooking.carbonEmissions;

import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementBookingData;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import java.util.Collection;
import java.util.stream.Stream;

class CarbonEmissionsHelper {
    CarbonEmissionsHelper() {
    }

    static Stream<MiscUtil.Pair<Segment, Product>> getApplicableSegments(ComplementBookingData complementData) {
        if (!CarbonEmissionsHelper.isAfsIncluded(complementData)) {
            return Stream.empty();
        }
        return complementData.getReservations().stream().flatMap(AirProductHelper::getAirProductsStream).flatMap(product -> {
            boolean isWithoutSeat = product.getPassengerType() != null && GdsDictHelper.isWithoutSeat((DictionaryReference)product.getPassengerType());
            return AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream().filter(segment -> CarbonEmissionsHelper.isApplicable(segment, isWithoutSeat)).map(segment -> new MiscUtil.Pair(segment, product));
        });
    }

    private static boolean isAfsIncluded(ComplementBookingData complementData) {
        if (complementData.getReservations().isEmpty()) {
            return false;
        }
        EntityReference customerRef = ((Reservation)complementData.getReservations().get(0)).getBookingFile().getCustomerProfile();
        EntityContainer customerCtr = EntityStorage.get().resolve(customerRef);
        if (customerCtr == null) {
            return false;
        }
        String afsSettings = ((Organization)customerCtr.getEntity()).getAfsSettings();
        return StatisticsHelper.getAfsTypesFromString((String)afsSettings).contains(AFSType.CO2_EMISSIONS);
    }

    private static boolean isApplicable(Segment segment, boolean isWithoutSeat) {
        return segment.getCo2EmissionsKg() == null && (isWithoutSeat || CarbonEmissionsHelper.hasIataCodes(segment));
    }

    private static boolean hasIataCodes(Segment segment) {
        return SabreServerHelper.hasIataCode(segment.getDepartureLocation()) && SabreServerHelper.hasIataCode(segment.getArriveLocation()) && SabreServerHelper.hasIataCode(segment.getAirline()) && SabreServerHelper.hasIataCode(segment.getBoard());
    }
}

