/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.complementBooking.carbonEmissions;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.complementBooking.carbonEmissions.CarbonEmissionsCache;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.triprecord.CarbonCalculatorRS;
import com.sabre.webservices.triprecord.CarbonEmissions;

public class CarbonEmissionsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        MiscUtil.Pair segmentAndProduct = (MiscUtil.Pair)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.SEGMENT_AND_PRODUCT);
        Segment segment = (Segment)segmentAndProduct.getFirst();
        Product product = (Product)segmentAndProduct.getSecond();
        if (GdsDictHelper.isWithoutSeat((DictionaryReference)product.getPassengerType())) {
            segment.setCo2EmissionsKg(Integer.valueOf(0));
        } else {
            CarbonEmissionsCache cache = CarbonEmissionsCache.get(ctx);
            Integer gdsValue = cache.getValue(segment);
            if (gdsValue == null) {
                CarbonCalculatorRS response = (CarbonCalculatorRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
                gdsValue = ((CarbonEmissions.Segment)response.getCarbonEmissions().getSegmentList().get(0)).getCO2Value().getPerPassenger().intValue();
                cache.setValue(segment, gdsValue);
            }
            segment.setCo2EmissionsKg(gdsValue);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.COMPLEMENT_BOOKING_WAS_CHANGED, (Object)true);
    }
}

