/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.complementBooking.getFlightDetails;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRS;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.time.FastDateFormat;

class FlightDetailsCache {
    private static final FastDateFormat DF_SEGMENT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final String IBUS_CONTEXT_KEY = FlightDetailsCache.class.getName();
    private final Map<List<String>, VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment> data = new HashMap<List<String>, VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment>();

    FlightDetailsCache() {
    }

    static FlightDetailsCache get(MessageContext ctx) {
        FlightDetailsCache cache = (FlightDetailsCache)ctx.getObject(IBUS_CONTEXT_KEY);
        if (cache == null) {
            cache = new FlightDetailsCache();
            ctx.putObject(IBUS_CONTEXT_KEY, (Object)cache);
        }
        return cache;
    }

    private static List<String> buildKey(Segment segment) {
        return Stream.concat(Stream.of(segment.getDepartureLocation(), segment.getArriveLocation(), segment.getAirline()).map(SabreHelper::getNativeCode), Stream.of(segment.getFlightNo(), DF_SEGMENT.format(segment.getStartDate()))).collect(Collectors.toList());
    }

    VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment getValue(Segment segment) {
        return this.data.get(FlightDetailsCache.buildKey(segment));
    }

    void setValue(Segment segment, VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment value) {
        this.data.put(FlightDetailsCache.buildKey(segment), value);
    }
}

