/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.complementBooking.getFlightDetails;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRQ;
import org.apache.commons.lang.time.FastDateFormat;

public class VerifyFlightDetailsRequestBuilder
extends BaseProcessor {
    private static final FastDateFormat DF_SEGMENT = FastDateFormat.getInstance((String)"MM-dd'T'HH:mm");

    public void process(MessageContext ctx) {
        Segment segment = (Segment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SEGMENT);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)this.buildRequest(segment));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"VerifyFlightDetailsLLSRQ");
    }

    private VerifyFlightDetailsRQ buildRequest(Segment segment) {
        VerifyFlightDetailsRQ request = new VerifyFlightDetailsRQ();
        VerifyFlightDetailsRQ.OriginDestinationInformation odi = new VerifyFlightDetailsRQ.OriginDestinationInformation();
        VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment fs = new VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment();
        fs.setDepartureDateTime(DF_SEGMENT.format(segment.getStartDate()));
        fs.setFlightNumber(segment.getFlightNo());
        VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.OriginLocation originLocation = new VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.OriginLocation();
        originLocation.setLocationCode(SabreHelper.getNativeCode((DictionaryReference)segment.getDepartureLocation()));
        fs.setOriginLocation(originLocation);
        VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.DestinationLocation destinationLocation = new VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.DestinationLocation();
        destinationLocation.setLocationCode(SabreHelper.getNativeCode((DictionaryReference)segment.getArriveLocation()));
        fs.setDestinationLocation(destinationLocation);
        VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.MarketingAirline marketingAirline = new VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.MarketingAirline();
        marketingAirline.setCode(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
        fs.setMarketingAirline(marketingAirline);
        odi.setFlightSegment(fs);
        request.setOriginDestinationInformation(odi);
        request.setVersion("2.0.1");
        return request;
    }
}

