/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.corp;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.corp.AbstractAFS;
import com.gridnine.xtrip.server.gds.sabre.corp.SabreAFS;
import com.gridnine.xtrip.server.gds.sabre.corp.SabreCommandAFS;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.EnumMap;
import java.util.Map;

public abstract class AbstractSabreAFS<T>
implements SabreAFS<T> {
    private static final Map<AFSType, SabreAFS> afsMap = new EnumMap<AFSType, SabreAFS>(AFSType.class);

    public static <T> SabreAFS<T> getSabreAFS(AFSType type) {
        return afsMap.get(type);
    }

    public static <T> SabreAFS<T> getMandatorySabreAFS(AFSType type) throws Xeption {
        SabreAFS<T> afs = AbstractSabreAFS.getSabreAFS(type);
        if (afs == null) {
            throw Xeption.forDeveloper((String)"No SabreAFS found for AFSType: ", (Object[])new Object[]{type.name()});
        }
        return afs;
    }

    public static SabreCommandAFS getSabreCommandAFS(AFSType type) {
        SabreAFS afs = afsMap.get(type);
        if (afs == null || !(afs instanceof SabreCommandAFS)) {
            throw Xeption.forDeveloper((String)"No SabreCommandAFS found for AFSType: ", (Object[])new Object[]{type.name()});
        }
        return (SabreCommandAFS)((Object)afs);
    }

    public static <T> PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createSabreRemark(int rkNumber, boolean isTicketing, String remarkValue, AFSType afsType, String description) {
        String sabreDescription = description;
        if (sabreDescription == null) {
            throw Xeption.forDeveloper((String)"Sabre AFS description is NULL for {0}", (Object[])new Object[]{afsType.name()});
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE);
        StringBuilder sb = new StringBuilder(64);
        sb.append("X*RK");
        sb.append(rkNumber);
        sb.append('*');
        sb.append(afsType.name());
        sb.append('*');
        sb.append(isTicketing ? "TKT" : "BKG");
        sb.append('*');
        sb.append(sabreDescription);
        sb.append('*');
        sb.append(remarkValue);
        sb.append('*');
        remark.setText(sb.toString());
        return remark;
    }

    @Override
    public PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createRemark(int rkNumber, boolean isTicketing, String remarkValue) {
        return AbstractSabreAFS.createSabreRemark(rkNumber, isTicketing, remarkValue, this.getAFSType(), this.getSabreDescription());
    }

    static {
        afsMap.put(AFSType.HBF1, new HBF1());
        afsMap.put(AFSType.HBF2, new HBF2());
        afsMap.put(AFSType.LAF1, new LAF1());
        afsMap.put(AFSType.LAF2, new LAF2());
        afsMap.put(AFSType.LAF3, new LAF3());
        afsMap.put(AFSType.ATF1, new ATF1());
        afsMap.put(AFSType.ATF2, new ATF2());
        afsMap.put(AFSType.LPF1, new LPF1());
        afsMap.put(AFSType.LPF2, new LPF2());
        afsMap.put(AFSType.LPF3, new LPF3());
        afsMap.put(AFSType.P3D, new P3D());
        afsMap.put(AFSType.DEST, new DEST());
        afsMap.put(AFSType.OCCL, new OCCL());
        afsMap.put(AFSType.VALC, new VALC());
    }

    private static final class DEST
    extends AbstractAFS.DEST
    implements SabreAFS<DictionaryReference<GeoLocation>> {
        private DEST() {
        }

        @Override
        public String getSabreDescription() {
            return "OVERALL.DESTINATION";
        }

        public AFSType getAFSType() {
            return super.getAFSType();
        }

        public DictionaryReference<GeoLocation> fromString(String stringValue) {
            return super.fromString(stringValue);
        }

        @Override
        public PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createRemark(int rkNumber, boolean isTicketing, String remarkValue) {
            return AbstractSabreAFS.createSabreRemark(rkNumber, isTicketing, remarkValue, this.getAFSType(), this.getSabreDescription());
        }
    }

    private static final class VALC
    extends AbstractAFS.VALC
    implements SabreAFS<DictionaryReference<Airline>> {
        private VALC() {
        }

        public AFSType getAFSType() {
            return super.getAFSType();
        }

        @Override
        public String getSabreDescription() {
            return "VALIDATING.CARRIER";
        }

        public DictionaryReference<Airline> fromString(String stringValue) {
            return super.fromString(stringValue);
        }

        @Override
        public PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createRemark(int rkNumber, boolean isTicketing, String remarkValue) {
            return AbstractSabreAFS.createSabreRemark(rkNumber, isTicketing, remarkValue, this.getAFSType(), this.getSabreDescription());
        }
    }

    private static final class OCCL
    extends AbstractAFS.OCCL
    implements SabreAFS<String> {
        private OCCL() {
        }

        public AFSType getAFSType() {
            return super.getAFSType();
        }

        @Override
        public String getSabreDescription() {
            return "OVERALL.CLASS.SERVC";
        }

        public String fromString(String stringValue) {
            return super.fromString(stringValue);
        }

        @Override
        public PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createRemark(int rkNumber, boolean isTicketing, String remarkValue) {
            return AbstractSabreAFS.createSabreRemark(rkNumber, isTicketing, remarkValue, this.getAFSType(), this.getSabreDescription());
        }
    }

    private static final class P3D
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private P3D() {
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setP3dTkt(value);
            } else {
                statData.setP3dBkg(value);
            }
        }

        @Override
        public String getSabreDescription() {
            return "FARE.PDISC.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPPL";
        }

        public AFSType getAFSType() {
            return AFSType.P3D;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "WPSUMT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALAIRPRICE";
        }
    }

    private static final class LPF3
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private LPF3() {
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setLpf3Tkt(value);
            } else {
                statData.setLpf3Bkg(value);
            }
        }

        @Override
        public String getSabreDescription() {
            return "LOW.ACX.SR.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNIS";
        }

        public AFSType getAFSType() {
            return AFSType.LPF3;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "TRPOPT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALEZTRIP00";
        }
    }

    private static final class LPF2
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private LPF2() {
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setLpf2Tkt(value);
            } else {
                statData.setLpf2Bkg(value);
            }
        }

        @Override
        public String getSabreDescription() {
            return "LOW.ANYDIR.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNIS/D";
        }

        public AFSType getAFSType() {
            return AFSType.LPF2;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "TRPOPT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALEZTRIP00";
        }
    }

    private static final class LPF1
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private LPF1() {
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setLpf1Tkt(value);
            } else {
                statData.setLpf1Bkg(value);
            }
        }

        @Override
        public String getSabreDescription() {
            return "LOW.SCX.SR.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNCS";
        }

        public AFSType getAFSType() {
            return AFSType.LPF1;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "WPSUMT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALAIRPRICE";
        }
    }

    private static final class ATF2
    extends AbstractAFS.ATF2
    implements SabreAFS<Double> {
        private ATF2() {
        }

        @Override
        public String getSabreDescription() {
            return "ACTUAL.TKT.INTAX";
        }

        public AFSType getAFSType() {
            return super.getAFSType();
        }

        public Double fromString(String stringValue) {
            return super.fromString(stringValue);
        }

        @Override
        public PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createRemark(int rkNumber, boolean isTicketing, String remarkValue) {
            return AbstractSabreAFS.createSabreRemark(rkNumber, isTicketing, remarkValue, this.getAFSType(), this.getSabreDescription());
        }
    }

    private static final class ATF1
    extends AbstractAFS.ATF1
    implements SabreAFS<Double>,
    SabreCommandAFS {
        private ATF1() {
        }

        public AFSType getAFSType() {
            return super.getAFSType();
        }

        @Override
        public String getSabreDescription() {
            return "ACTUAL.TKT.EXTAX";
        }

        @Override
        public String getSabreCommand() {
            return null;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "WPINFO";
        }

        @Override
        public String getSabrePricingElementTagName() {
            return "equivalentAmountPaid";
        }

        @Override
        public String getAlternatePricingElementTagName() {
            return "baseFare";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALAIRPRICE";
        }

        public Double fromString(String stringValue) {
            return super.fromString(stringValue);
        }

        @Override
        public PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createRemark(int rkNumber, boolean isTicketing, String remarkValue) {
            return AbstractSabreAFS.createSabreRemark(rkNumber, isTicketing, remarkValue, this.getAFSType(), this.getSabreDescription());
        }
    }

    private static final class LAF3
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private LAF3() {
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setLaf3Tkt(value);
            } else {
                statData.setLaf3Bkg(value);
            }
        }

        @Override
        public String getSabreDescription() {
            return "LOW.ANYDIR.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNI/D";
        }

        public AFSType getAFSType() {
            return AFSType.LAF3;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "TRPOPT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALEZTRIP00";
        }
    }

    private static final class LAF2
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private LAF2() {
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setLaf2Tkt(value);
            } else {
                statData.setLaf2Bkg(value);
            }
        }

        @Override
        public String getSabreDescription() {
            return "LOW.AV.SCX.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNC";
        }

        public AFSType getAFSType() {
            return AFSType.LAF2;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "WPSUMT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALAIRPRICE";
        }
    }

    private static final class LAF1
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private LAF1() {
        }

        public AFSType getAFSType() {
            return AFSType.LAF1;
        }

        @Override
        public String getSabreDescription() {
            return "LOW.AV.ACX.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNI";
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setLaf1Tkt(value);
            } else {
                statData.setLaf1Bkg(value);
            }
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "TRPOPT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALEZTRIP00";
        }
    }

    private static class HBF2
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private HBF2() {
        }

        public AFSType getAFSType() {
            return AFSType.HBF2;
        }

        @Override
        public String getSabreDescription() {
            return "HIGH.BNCHM.INTAX";
        }

        @Override
        public String getSabreCommand() {
            return "WPNC\u00a5NL\u00a5XR";
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setHbf2Tkt(value);
            } else {
                statData.setHbf2Bkg(value);
            }
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "WPSUMT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALAIRPRICE";
        }
    }

    private static class HBF1
    extends SabreDoubleAFS
    implements SabreCommandAFS {
        private HBF1() {
        }

        @Override
        public String getSabreDescription() {
            return "HIGH.BNCHM.EXTAX";
        }

        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setHbf1Tkt(value);
            } else {
                statData.setHbf1Bkg(value);
            }
        }

        @Override
        public String getSabreCommand() {
            return "WPNC\u00a5NL\u00a5XR\u00a5TN";
        }

        public AFSType getAFSType() {
            return AFSType.HBF1;
        }

        @Override
        public String getSabrePricingBlockTagName() {
            return "WPSUMT";
        }

        @Override
        public String getSabreMainTagName() {
            return "AIRAALAIRPRICE";
        }
    }

    protected static abstract class SabreDoubleAFS
    extends AbstractSabreAFS<Double> {
        protected SabreDoubleAFS() {
        }

        public final Double fromString(String stringValue) {
            return Double.valueOf(stringValue);
        }

        public final String convertToString(Double value) {
            return value.toString();
        }

        public String getSabrePricingElementTagName() {
            return "totalPassengers";
        }

        public String getAlternatePricingElementTagName() {
            return null;
        }
    }
}

