/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.NoAirlineLocatorException;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;

public class AirlineLocatorExceptionParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        HashSet segmentIterators = new HashSet();
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            ArrayList segments = new ArrayList();
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                segments.addAll(st.getSegments());
            }
            segmentIterators.add(segments.iterator());
        }
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        for (AirType fs : GetReservationHelper.getAirs(response)) {
            Matcher airlineLocatorMatcher = GetReservationHelper.PATTERN_SUPPLIER_REF.matcher(fs.getAirlineRefId());
            if (airlineLocatorMatcher.matches()) {
                String airlineLocator = airlineLocatorMatcher.group(1);
                for (Iterator iterator : segmentIterators) {
                    ((Segment)iterator.next()).setAirlineLocator(airlineLocator);
                }
                continue;
            }
            throw new NoAirlineLocatorException();
        }
    }
}

