/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerReservationPNRB;
import java.util.List;

public class CheckUnheldSessionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        List segments = FlightHelper.getSegments((Flight)flight);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        PassengerReservationPNRB passengerReservation = response.getReservation().getReservationChoiceGroup().getPassengerReservation();
        if (passengerReservation != null && passengerReservation.getPassengers() != null && passengerReservation.getPassengers().getPassengerList() != null && !passengerReservation.getPassengers().getPassengerList().isEmpty()) {
            throw Xeption.forDeveloper((String)"wrong sabre session", (Object[])new Object[0]);
        }
        List<AirType> airs = GetReservationHelper.getAirs(response);
        if (segments.size() != airs.size()) {
            throw Xeption.forDeveloper((String)"wrong sabre session", (Object[])new Object[0]);
        }
        for (int i = 0; i < segments.size(); ++i) {
            FlightSegment segment = (FlightSegment)segments.get(i);
            AirType gdsSegment = airs.get(i);
            if (!SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()).equals(gdsSegment.getMarketingAirlineCode())) {
                throw Xeption.forDeveloper((String)"wrong sabre session", (Object[])new Object[0]);
            }
            if (segment.getFlightNumber().equals(GetReservationHelper.getFlightNumber(gdsSegment))) continue;
            throw Xeption.forDeveloper((String)"wrong sabre session", (Object[])new Object[0]);
        }
    }
}

