/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

public class EnforceAgedChildrenPassengerTypesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            if (!DictHelper.isChildPassengerType((DictionaryReference)gdsTraveller.getPassengerType())) continue;
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
            int age = Years.yearsBetween((ReadableInstant)new DateTime((Object)traveller.getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)FlightHelper.getFirstDepartureTime((Flight)parameters.getFlight()))).getYears();
            gdsTraveller.setPassengerType(DictHelper.getChildPassengerType((int)age));
        }
    }
}

