/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GdsTravellerAirPriceRQParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        final Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        final SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        final Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        final Boolean isSuOnBsp = SabreHelper.isSuOnBsp((Flight)flight, (SalesContext)salesContext);
        GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Map nameNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        SpecialTariff specialTariff = flight.getSpecialTariff() != null ? (SpecialTariff)EntityStorage.get().resolve(flight.getSpecialTariff()).getEntity() : null;
        final GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        final Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        ImmutableListMultimap gdsTravellerByUniqueQualifiers = Multimaps.index((Iterable)params.getGdsTravellers(), (Function)new Function<GdsTraveller, AirPriceHelper.UniqueQualifiers>(){

            public AirPriceHelper.UniqueQualifiers apply(GdsTraveller gdsTraveller) {
                try {
                    DictionaryReference ptRef = SabreHelper.autocorrectPassengerType((DictionaryReference)gdsTraveller.getPassengerType(), (Flight)flight);
                    Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
                    AirPriceHelper.UniqueQualifiers result = new AirPriceHelper.UniqueQualifiers();
                    result.commission = AirPriceHelper.buildCommissionQualifier(SabreHelper.getTotalVendorCommissionForSabre((Flight)flight, (DictionaryReference)ptRef), flight.getGdsCurrencyCode());
                    result.endorsement = SabreServerHelper.buildEndorsement(gdsParameters, flight, (DictionaryReference<PassengerType>)gdsTraveller.getPassengerType(), salesContext, traveller, customer);
                    result.suOnBsp = isSuOnBsp;
                    result.brandIds = AirPriceHelper.getBrandIds(flight, (DictionaryReference<PassengerType>)ptRef);
                    if (flight.isSabreSmartPricePricing()) {
                        result.smartPriceFareBasises = AirPriceHelper.getSmartPriceFareBasises(flight, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType());
                    }
                    result.publicFare = AirPriceHelper.getPublicFare(flight, (DictionaryReference<PassengerType>)ptRef);
                    result.refundableAny = AirPriceHelper.getRefundableAny(flight, (DictionaryReference<PassengerType>)ptRef);
                    result.privateFare = Boolean.TRUE.equals(flight.getPrivateFare().get(ptRef));
                    result.vatInfo = SabreServerHelper.buildEndorsementVatInfo(flight, (DictionaryReference<PassengerType>)gdsTraveller.getPassengerType());
                    return result;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        ArrayList<AirPriceRQParameters> result = new ArrayList<AirPriceRQParameters>();
        HashMap<String, String> endorsements = new HashMap<String, String>();
        for (Map.Entry entry : gdsTravellerByUniqueQualifiers.asMap().entrySet()) {
            AirPriceHelper.UniqueQualifiers uq = (AirPriceHelper.UniqueQualifiers)entry.getKey();
            ImmutableListMultimap gdsTravellerByType = Multimaps.index((Iterable)((Iterable)entry.getValue()), (Function)new Function<GdsTraveller, String>(){

                public String apply(GdsTraveller gdsTraveller) {
                    return SabreHelper.getNativeCode((DictionaryReference)gdsTraveller.getPassengerType());
                }
            });
            ArrayList types = new ArrayList(gdsTravellerByType.keySet());
            Collections.sort(types);
            for (List atomicTypes : Lists.partition(types, (int)4)) {
                ArrayList<GdsTraveller> atomicGdsTravellers = new ArrayList<GdsTraveller>();
                for (String atomicType : atomicTypes) {
                    for (GdsTraveller gt : gdsTravellerByType.get((Object)atomicType)) {
                        atomicGdsTravellers.add(gt);
                    }
                }
                AirPriceRQParameters parameters = new AirPriceRQParameters();
                parameters.setGdsAccount(flight.getGdsAccount());
                if (!StringUtils.isBlank((String)flight.getAccountCode())) {
                    parameters.getAccountCodes().add(flight.getAccountCode());
                }
                parameters.setCorporateId(flight.getCorporateId());
                if (gdsParameters.getValidatingCarrier() != null) {
                    parameters.setCarrier(gdsParameters.getValidatingCarrier());
                } else {
                    parameters.setCarrier(flight.getCarrier());
                }
                parameters.setGdsCurrencyCode(flight.getGdsCurrencyCode());
                DictionaryReference ptRef = SabreHelper.autocorrectPassengerType((DictionaryReference)((GdsTraveller)gdsTravellerByType.get(atomicTypes.get(0)).iterator().next()).getPassengerType(), (Flight)flight);
                parameters.setCommission(SabreHelper.getTotalVendorCommissionForSabre((Flight)flight, (DictionaryReference)ptRef));
                for (String atomicType : atomicTypes) {
                    parameters.getPassengerTypes().add(new MiscUtil.Pair((Object)atomicType, (Object)gdsTravellerByType.get((Object)atomicType).size()));
                }
                for (GdsTraveller atomicGdsTraveller : atomicGdsTravellers) {
                    parameters.getNameNumbers().add(nameNumbers.get(atomicGdsTraveller.getTravellerUid()));
                    endorsements.put(atomicGdsTraveller.getTravellerUid(), uq.endorsement);
                }
                parameters.setRetain(true);
                parameters.setTourCode(flight.getTourCode());
                parameters.setTripartiteContractDetails(flight.getTripartiteContractDetails());
                if (specialTariff != null) {
                    parameters.setExemptAllTaxes(specialTariff.isExcludeTaxes());
                    parameters.setResidentCountry(specialTariff.getResidentCountry());
                }
                parameters.setEndorsement(uq.endorsement);
                for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
                    parameters.getSegmentNumbers().add(fs.getGdsId());
                }
                if (uq.brandIds != null) {
                    parameters.getBrandIds().addAll(uq.brandIds);
                }
                if (uq.smartPriceFareBasises != null) {
                    parameters.getSmartPriceFareBasises().addAll(uq.smartPriceFareBasises);
                }
                parameters.setPublicFare(uq.publicFare);
                parameters.setRefundableAny(uq.refundableAny);
                if (SabreHelper.isTchBlankOwner((EntityReference)flight.getBlankOwner())) {
                    parameters.setValidationMethod("TCH");
                }
                parameters.setVatInfo(uq.vatInfo);
                parameters.setSupplier(GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER));
                parameters.setBlankOwner(flight.getBlankOwner());
                result.add(parameters);
            }
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.ENDORSEMENTS, endorsements);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS_SET, result);
    }
}

