/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestCategory;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileLineDataProxy;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class PassengerDetailsProfileRemarksHelper {
    public static void addProfileRemarks(PassengerDetailsRQ request, List<SabreProfileLine> additionalProfileLines, List<String> sabreFreeTextRemarks, List<SabreProfileCommand2Osi> sabreAdditionalCommand2Lines, List<SabreProfileCommand4SSR> sabreAdditionalCommand4Lines, Flight flight) {
        List<String> marketingAirlineCodes = FlightHelper.getSegments((Flight)flight).stream().map(FlightSegment::getAirline).map(SabreHelper::getNativeCode).collect(Collectors.toList());
        List<String> segmentGdsIds = FlightHelper.getSegments((Flight)flight).stream().map(FlightSegment::getGdsId).collect(Collectors.toList());
        PassengerDetailsProfileRemarksHelper.addProfileRemarks(request, additionalProfileLines, sabreFreeTextRemarks, sabreAdditionalCommand2Lines, sabreAdditionalCommand4Lines, marketingAirlineCodes, segmentGdsIds);
    }

    private static void addProfileRemarks(PassengerDetailsRQ request, List<SabreProfileLine> additionalProfileLines, List<String> sabreFreeTextRemarks, List<SabreProfileCommand2Osi> sabreAdditionalCommand2Lines, List<SabreProfileCommand4SSR> sabreAdditionalCommand4Lines, List<String> marketingAirlineCodes, List<String> segmentGdsIds) {
        PassengerDetailsProfileRemarksHelper.addAdditionalProfileLines(request, additionalProfileLines);
        PassengerDetailsProfileRemarksHelper.addSabreFreeTextRemarks(request, sabreFreeTextRemarks);
        PassengerDetailsProfileRemarksHelper.addSabreAdditionalCommand2Lines(request, sabreAdditionalCommand2Lines, marketingAirlineCodes);
        PassengerDetailsProfileRemarksHelper.addSabreAdditionalCommand4Lines(request, sabreAdditionalCommand4Lines, marketingAirlineCodes, segmentGdsIds);
    }

    private static void addAdditionalProfileLines(PassengerDetailsRQ request, List<SabreProfileLine> additionalProfileLines) {
        TreeMap remarksMap = new TreeMap();
        ProfileSynchronizationUtil.addGeneralRemarks(additionalProfileLines, (String)"AAA", (boolean)true, remarksMap);
        for (SabreProfileLineServiceType serviceType : SabreProfileLineServiceType.values()) {
            for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)serviceType), (String)"AAA", (boolean)false)) {
                PassengerDetailsProfileRemarksHelper.addAlphaCodedRemark(request, proxy);
            }
        }
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)"AAA", (String)"AAA", (boolean)false)) {
            PassengerDetailsProfileRemarksHelper.addAlphaCodedRemark(request, proxy);
        }
    }

    private static void addSabreFreeTextRemarks(PassengerDetailsRQ request, List<String> sabreFreeTextRemarks) {
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createFreeTextRemarksList(sabreFreeTextRemarks)) {
            PassengerDetailsProfileRemarksHelper.addGeneralRemark(request, proxy);
        }
    }

    private static void addSabreAdditionalCommand2Lines(PassengerDetailsRQ request, List<SabreProfileCommand2Osi> sabreAdditionalCommand2Lines, List<String> marketingAirlineCodesBySegment) {
        List lines = sabreAdditionalCommand2Lines.stream().filter(osi -> PassengerDetailsProfileRemarksHelper.isOsiApplicable(osi, marketingAirlineCodesBySegment)).collect(Collectors.toList());
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createSabreAdditionalCommands(Collections.emptyList(), lines, Collections.emptyList(), Collections.emptyList())) {
            PassengerDetailsProfileRemarksHelper.addOsi(request, proxy);
        }
    }

    private static void addSabreAdditionalCommand4Lines(PassengerDetailsRQ request, List<SabreProfileCommand4SSR> sabreAdditionalCommand4Lines, List<String> marketingAirlineCodesBySegment, List<String> segmentGdsIds) {
        List lines = sabreAdditionalCommand4Lines.stream().filter(ssr -> PassengerDetailsProfileRemarksHelper.isSsrApplicable(ssr, marketingAirlineCodesBySegment)).collect(Collectors.toList());
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createSabreAdditionalCommands(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), lines)) {
            PassengerDetailsProfileRemarksHelper.addSsrs(request, proxy, marketingAirlineCodesBySegment, segmentGdsIds);
        }
    }

    private static boolean isSsrApplicable(SabreProfileCommand4SSR ssr, Collection<String> marketingAirlineCodes) {
        if (ssr.getLineType() == SabreProfileLineType.O) {
            return false;
        }
        if (ssr.getSsrCode() == null || ssr.getSsrCode().length() != 6) {
            return true;
        }
        return marketingAirlineCodes.contains(ssr.getSsrCode().substring(4, 6));
    }

    private static boolean isOsiApplicable(SabreProfileCommand2Osi osi, Collection<String> marketingAirlineCodes) {
        if (osi.getLineType() == SabreProfileLineType.O) {
            return false;
        }
        if ("YY".equals(osi.getEntry1())) {
            return true;
        }
        return marketingAirlineCodes.contains(osi.getEntry1());
    }

    private static void addSsrs(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy, List<String> marketingAirlinesBySegment, List<String> segmentGdsIds) {
        String text;
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        String ssrCodeWithSuffix = proxy.getLine().contains("/") ? proxy.getLine().substring(1, proxy.getLine().indexOf(47)) : proxy.getLine().substring(1);
        String ssrCode = ssrCodeWithSuffix.length() == 6 ? ssrCodeWithSuffix.substring(0, 4) : ssrCodeWithSuffix;
        String airline = ssrCodeWithSuffix.length() == 6 ? ssrCodeWithSuffix.substring(4, 6) : null;
        String string = text = proxy.getLine().contains("/") ? proxy.getLine().substring(proxy.getLine().indexOf(47) + 1) : null;
        if (airline == null) {
            PassengerDetailsHelper.addSsr(ssrCode, null, null, text, request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        } else {
            for (int i = 0; i < marketingAirlinesBySegment.size(); ++i) {
                if (!airline.equals(marketingAirlinesBySegment.get(i))) continue;
                PassengerDetailsHelper.addSsr(ssrCode, segmentGdsIds.get(i), null, text, request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
                if (ssrCode.contains("CLID")) break;
            }
        }
    }

    private static void addOsi(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service service = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service();
        service.setSSRCode("OSI");
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.VendorPrefs vendorPrefs = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.VendorPrefs();
        vendorPrefs.setAirlineCode(proxy.getLine().substring(5, 7));
        service.setVendorPrefs(vendorPrefs);
        service.setText(proxy.getLine().substring(8));
        request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList().add(service);
    }

    private static void addAlphaCodedRemark(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.ALPHA_CODED);
        remark.setCode(proxy.getLine().substring(1, 2));
        remark.setText(proxy.getLine().substring(3));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    private static void addGeneralRemark(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.GENERAL);
        remark.setText(proxy.getLine().substring(1));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    public static void addItineraryRemark(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.ITINERARY);
        remark.setText(proxy.getLine().substring(2));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    public static void removeMealSsr(PassengerDetailsRQ request) {
        request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList().removeIf(service -> {
            String code = service.getSSRCode();
            if (TextUtil.isBlank((String)code)) {
                return false;
            }
            return DictHelper.getSpecialServiceRequestsByCategory((SpecialServiceRequestCategory)SpecialServiceRequestCategory.MEALS).stream().anyMatch(dict -> dict.getCodeVariants().values().stream().anyMatch(codeVariant -> TextUtil.isSame((String)code, (String)codeVariant, (boolean)true)));
        });
    }
}

