/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescriptionItem;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.AncillaryPricePNRB;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesDataGroupPNRB;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesUpdatePNRB;
import com.sabre.webservices.pnrbuilder.v119.BasicAncillaryServicesDataGroupPNRB;
import com.sabre.webservices.pnrbuilder.v119.FactTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.LocatorWithPartitionType;
import com.sabre.webservices.pnrbuilder.v119.NameAssociationListPNRB;
import com.sabre.webservices.pnrbuilder.v119.NameAssociationTagPNRB;
import com.sabre.webservices.pnrbuilder.v119.OperationTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.OptionalAncillaryServicesInformationDataGroupPNRB;
import com.sabre.webservices.pnrbuilder.v119.ReceivedFromPNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestEnumerationType;
import com.sabre.webservices.pnrbuilder.v119.RequestType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateItemType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateListType;
import com.sabre.webservices.pnrbuilder.v119.ReturnOptions;
import com.sabre.webservices.pnrbuilder.v119.SegmentAssociationListPNRB;
import com.sabre.webservices.pnrbuilder.v119.SegmentAssociationTagPNRB;
import com.sabre.webservices.pnrbuilder.v119.SpecialServicePNRB;
import com.sabre.webservices.pnrbuilder.v119.SpecialServiceRequestUpdatePNRB;
import com.sabre.webservices.pnrbuilder.v119.UpdateReservationRQ;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateReservationRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Map nameNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        UpdateReservationRQ request = this.buildRequest(response.getReservation().getBookingDetails().getRecordLocator(), ((SabreGdsAccount)accountCtr.getEntity()).getTransactionExecutor(), flight, travellers, nameNumbers, params, response);
        request.setVersion("1.19.11");
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"UpdateReservationRQ");
    }

    private UpdateReservationRQ buildRequest(String locatorId, String agentName, Flight flight, Collection<Traveller> travellers, Map<String, String> nameNumbers, GdsReservationCreationParameters params, GetReservationRSType response) throws Exception {
        UpdateReservationRQ request = this.createRequest(locatorId, agentName);
        List segments = FlightHelper.getSegments((Flight)flight);
        List<String> segmentStatuses = this.getSegmentStatuses(response);
        this.fillRequest(flight, travellers, nameNumbers, segments, segmentStatuses, params, request);
        return request;
    }

    private UpdateReservationRQ createRequest(String locatorId, String agentName) {
        UpdateReservationRQ request = new UpdateReservationRQ();
        ReturnOptions returnOptions = new ReturnOptions();
        returnOptions.setIncludeUpdateDetails(Boolean.valueOf(true));
        returnOptions.setRetrievePNR(Boolean.valueOf(true));
        request.setReturnOptions(returnOptions);
        RequestType requestType = new RequestType();
        requestType.setCommitTransaction(Boolean.valueOf(true));
        requestType.setInitialIgnore(Boolean.valueOf(true));
        requestType.setRequestEnumerationType(RequestEnumerationType.STATELESS);
        request.setRequestType(requestType);
        ReservationUpdateListType reservationUpdateListType = new ReservationUpdateListType();
        LocatorWithPartitionType locator = new LocatorWithPartitionType();
        locator.setString(locatorId);
        reservationUpdateListType.setLocator(locator);
        ReceivedFromPNRB receivedFrom = new ReceivedFromPNRB();
        receivedFrom.setAgentName(agentName);
        reservationUpdateListType.setReceivedFrom(receivedFrom);
        ReservationUpdateListType.Choice choice = new ReservationUpdateListType.Choice();
        reservationUpdateListType.setChoice(choice);
        request.setReservationUpdateList(reservationUpdateListType);
        return request;
    }

    private void fillRequest(Flight flight, Collection<Traveller> travellers, Map<String, String> nameNumbers, List<FlightSegment> segments, List<String> segmentStatuses, GdsReservationCreationParameters params, UpdateReservationRQ request) {
        for (GdsTraveller gdsTraveller : params.getGdsTravellers()) {
            for (AncillaryFeeReservationParameters ancillaryFeeFromParams : gdsTraveller.getAncillaryFees()) {
                AncillaryFee ancillaryFee = flight.getAncillaryFees().stream().filter(flightAncillaryFee -> flightAncillaryFee.getGdsId().equals(ancillaryFeeFromParams.getGdsId())).filter(flightAncillaryFee -> flightAncillaryFee.getType() == AncillaryFeeType.BAGGAGE).findFirst().orElse(null);
                if (ancillaryFee == null) continue;
                ReservationUpdateItemType reservationUpdateItem = new ReservationUpdateItemType();
                AncillaryServicesUpdatePNRB ancillaryServicesUpdate = new AncillaryServicesUpdatePNRB();
                ancillaryServicesUpdate.setOp(OperationTypePNRB.C);
                Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
                NameAssociationListPNRB nameAssociationList = this.getNameAssociationList(flight, nameNumbers, traveller, gdsTraveller);
                ancillaryServicesUpdate.setNameAssociationList(nameAssociationList);
                SegmentAssociationListPNRB associationList = this.getSegmentAssociationList(segments, segmentStatuses, ancillaryFee);
                SegmentAssociationListPNRB segmentAssociationList = new SegmentAssociationListPNRB();
                segmentAssociationList.getSegmentAssociationTagList().addAll(associationList.getSegmentAssociationTagList());
                ancillaryServicesUpdate.setSegmentAssociationList(segmentAssociationList);
                AncillaryServicesDataGroupPNRB ancillaryServicesDataGroup = new AncillaryServicesDataGroupPNRB();
                ancillaryServicesDataGroup.setNumberOfItems(String.valueOf(ancillaryFeeFromParams.getQuantity()));
                ancillaryServicesDataGroup.setGroupCode(SabreCustomPropertiesHelper.getAncillaryGroupCode(ancillaryFee));
                BasicAncillaryServicesDataGroupPNRB basicAncillaryServicesDataGroup = new BasicAncillaryServicesDataGroupPNRB();
                basicAncillaryServicesDataGroup.setCommercialName(ancillaryFee.getGdsDescription());
                basicAncillaryServicesDataGroup.setRficCode(SabreCustomPropertiesHelper.getRficCode(ancillaryFee));
                basicAncillaryServicesDataGroup.setRficSubcode(SabreCustomPropertiesHelper.getRficSubcode(ancillaryFee));
                String ssrCode = SabreCustomPropertiesHelper.getSSRCode(ancillaryFee);
                if (!TextUtil.isBlank((String)ssrCode)) {
                    basicAncillaryServicesDataGroup.setSSRCode(ssrCode);
                    if (!ssrCode.equals("ASVC") && !associationList.getSegmentAssociationTagList().isEmpty()) {
                        FlightSegment straightSegment = segments.get(0);
                        this.addSsr(ancillaryFee, nameAssociationList, associationList, ssrCode, (DictionaryReference<Airline>)straightSegment.getAirline(), flight.getGds(), request);
                    }
                }
                basicAncillaryServicesDataGroup.setOwningCarrierCode(SabreHelper.getNativeCode((DictionaryReference)flight.getCarrier()));
                basicAncillaryServicesDataGroup.setEMDType(SabreCustomPropertiesHelper.getEMDType(ancillaryFee));
                basicAncillaryServicesDataGroup.setServiceType("C");
                OptionalAncillaryServicesInformationDataGroupPNRB optionalInformation = new OptionalAncillaryServicesInformationDataGroupPNRB();
                AncillaryPricePNRB originalBasePrice = new AncillaryPricePNRB();
                originalBasePrice.setPrice(ancillaryFee.getBaseAmount().getValue());
                originalBasePrice.setCurrency(ancillaryFee.getBaseAmount().getCurrency());
                optionalInformation.setOriginalBasePrice(originalBasePrice);
                ancillaryServicesDataGroup.setBasicAncillaryServicesDataGroupPNRB(basicAncillaryServicesDataGroup);
                ancillaryServicesDataGroup.setOptionalAncillaryServicesInformationDataGroupPNRB(optionalInformation);
                ancillaryServicesUpdate.setAncillaryServicesDataGroupPNRB(ancillaryServicesDataGroup);
                reservationUpdateItem.clearChoiceSelect();
                reservationUpdateItem.setAncillaryServicesUpdate(ancillaryServicesUpdate);
                request.getReservationUpdateList().getChoice().getReservationUpdateItemList().add(reservationUpdateItem);
            }
        }
    }

    public void addSsr(AncillaryFee ancillaryFee, NameAssociationListPNRB nameAssociationList, SegmentAssociationListPNRB segmentAssociationList, String ssrCode, DictionaryReference<Airline> marketingAirline, GdsName gdsName, UpdateReservationRQ request) {
        ReservationUpdateItemType ssrUpdateItem = new ReservationUpdateItemType();
        this.setSsrText(ancillaryFee, ssrUpdateItem, nameAssociationList, segmentAssociationList, ssrCode, gdsName, marketingAirline);
        request.getReservationUpdateList().getChoice().getReservationUpdateItemList().add(ssrUpdateItem);
    }

    private void setSsrText(AncillaryFee ancillaryFee, ReservationUpdateItemType reservationUpdateItem, NameAssociationListPNRB nameAssociationList, SegmentAssociationListPNRB segmentAssociationList, String ssrCode, GdsName gdsName, DictionaryReference<Airline> marketingAirline) {
        SpecialServiceRequestUpdatePNRB ssrUpdate = new SpecialServiceRequestUpdatePNRB();
        ssrUpdate.setOp(OperationTypePNRB.C);
        ssrUpdate.setType(FactTypePNRB.G);
        SpecialServiceRequestUpdatePNRB.Choice ssChoise = new SpecialServiceRequestUpdatePNRB.Choice();
        SpecialServicePNRB specialService = new SpecialServicePNRB();
        specialService.setCode(ssrCode);
        ssrUpdate.setNameAssociationList(nameAssociationList);
        String serviceDetailsType = SabreCustomPropertiesHelper.getSpecialServiceDetailsType(ancillaryFee);
        if (serviceDetailsType.equals("STRUCTURED") || serviceDetailsType.equals("REQUIRED")) {
            AncillaryFeeDescription ancillaryFeeDescription = (AncillaryFeeDescription)DictHelper.resolve((DictionaryReference)ancillaryFee.getDescription());
            specialService.setText(this.findSsrText(ancillaryFeeDescription, marketingAirline, SabreCustomPropertiesHelper.getRficSubcode(ancillaryFee), gdsName));
        }
        ssChoise.setSpecialService(specialService);
        ssrUpdate.setChoice(ssChoise);
        ssrUpdate.setSegmentAssociationList(segmentAssociationList);
        reservationUpdateItem.clearChoiceSelect();
        reservationUpdateItem.setSpecialServiceRequestUpdate(ssrUpdate);
    }

    private String findSsrText(AncillaryFeeDescription ancillaryFeeDescription, DictionaryReference<Airline> airline, String rficSubcode, GdsName gdsName) {
        if (ancillaryFeeDescription.getDescriptionItems().size() > 1) {
            Optional<AncillaryFeeDescriptionItem> optionalItem = ancillaryFeeDescription.getDescriptionItems().stream().filter(item -> item.getAirline().equals((Object)airline) && item.getServiceCode().equals(rficSubcode) && item.getGds().equals((Object)gdsName)).findFirst();
            return optionalItem.map(AncillaryFeeDescriptionItem::getServiceName).orElse(null);
        }
        return ((AncillaryFeeDescriptionItem)ancillaryFeeDescription.getDescriptionItems().get(0)).getServiceName();
    }

    private SegmentAssociationListPNRB getSegmentAssociationList(List<FlightSegment> segments, List<String> segmentStatuses, AncillaryFee ancillaryFee) {
        SegmentAssociationListPNRB straightSegmentAssociationList = new SegmentAssociationListPNRB();
        for (Integer segmentNumber : ancillaryFee.getSegmentNumbers()) {
            FlightSegment segment = segments.get(segmentNumber);
            SegmentAssociationTagPNRB segmentAssociationTag = new SegmentAssociationTagPNRB();
            segmentAssociationTag.setCarrierCode(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
            segmentAssociationTag.setFlightNumber(segment.getFlightNumber());
            segmentAssociationTag.setDepartureDate(new Date(segment.getDateBegin().getTime()));
            segmentAssociationTag.setBoardPoint(SabreHelper.getNativeCode((DictionaryReference)segment.getLocationBegin()));
            segmentAssociationTag.setOffPoint(SabreHelper.getNativeCode((DictionaryReference)segment.getLocationEnd()));
            segmentAssociationTag.setClassOfService(segment.getBookingClass());
            segmentAssociationTag.setBookingStatus(segmentStatuses.get(segmentNumber));
            straightSegmentAssociationList.getSegmentAssociationTagList().add(segmentAssociationTag);
        }
        return straightSegmentAssociationList;
    }

    private List<String> getSegmentStatuses(GetReservationRSType response) {
        ArrayList<String> statuses = new ArrayList<String>();
        for (AirType air : GetReservationHelper.getAirs(response)) {
            statuses.add(air.getActionCode());
        }
        return statuses;
    }

    private NameAssociationListPNRB getNameAssociationList(Flight flight, Map<String, String> nameNumbers, Traveller traveller, GdsTraveller gdsTraveller) {
        NameAssociationListPNRB nameAssociationList = new NameAssociationListPNRB();
        NameAssociationTagPNRB nameAssociationTag = new NameAssociationTagPNRB();
        nameAssociationTag.setFirstName(SabreHelper.buildGivenName((Passport)traveller.getPassport(), (DictionaryReference)gdsTraveller.getPassengerType(), (SabreHelper.SabreAviaParametersProvider)new SabreHelper.FlightParametersProvider(flight, traveller.getPassport())));
        nameAssociationTag.setLastName(SabreHelper.buildSurname((Passport)traveller.getPassport(), (boolean)true));
        nameAssociationTag.setNameRefNumber(nameNumbers.get(gdsTraveller.getTravellerUid()));
        nameAssociationList.getNameAssociationTagList().add(nameAssociationTag);
        return nameAssociationList;
    }
}

