/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AircraftSeatReservationParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.updatereservation.v11.UpdatePassengerNameRecordRQ;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.math.BigInteger;
import java.util.Map;

public class UpdateReservationWithAirSeatsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Map nameNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        UpdatePassengerNameRecordRQ request = new UpdatePassengerNameRecordRQ();
        UpdatePassengerNameRecordRQ.SpecialReqDetails srd = new UpdatePassengerNameRecordRQ.SpecialReqDetails();
        UpdatePassengerNameRecordRQ.SpecialReqDetails.AirSeat airSeat = new UpdatePassengerNameRecordRQ.SpecialReqDetails.AirSeat();
        for (GdsTraveller gdsTraveller : params.getGdsTravellers()) {
            gdsTraveller.getSeatsReservationParameters().forEach(seatParams -> {
                String travellerNameNumber = (String)nameNumbers.get(gdsTraveller.getTravellerUid());
                airSeat.getSeatList().add(this.buildSeat(travellerNameNumber, (AircraftSeatReservationParameters)seatParams));
            });
        }
        srd.setAirSeat(airSeat);
        request.setSpecialReqDetails(srd);
        request.setVersion("1.1.0");
        request.setPostProcessing(new UpdatePassengerNameRecordRQ.PostProcessing());
        UpdatePassengerNameRecordRQ.PostProcessing.RedisplayReservation rr = new UpdatePassengerNameRecordRQ.PostProcessing.RedisplayReservation();
        rr.setWaitInterval(BigInteger.valueOf(2000L));
        request.getPostProcessing().setRedisplayReservation(rr);
        request.getPostProcessing().setEndTransactionSource(((SabreGdsAccount)accountCtr.getEntity()).getTransactionExecutor());
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        request.setItinerary(response.getReservation().getBookingDetails().getRecordLocator());
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"UpdatePassengerNameRecordRQ");
    }

    private UpdatePassengerNameRecordRQ.SpecialReqDetails.AirSeat.Seat buildSeat(String travellerNameNumber, AircraftSeatReservationParameters seatParams) {
        UpdatePassengerNameRecordRQ.SpecialReqDetails.AirSeat.Seat seat = new UpdatePassengerNameRecordRQ.SpecialReqDetails.AirSeat.Seat();
        seat.setNameNumber(travellerNameNumber);
        seat.setNumber(seatParams.getSeatNumber());
        seat.setSegmentNumber(seatParams.getSegmentId());
        return seat;
    }
}

