/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation.remarks;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRQ;

public final class AfsAirPriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OTAAirPriceRQ req;
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_TYPE);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        switch (afsType) {
            case HBF1: {
                req = AfsAirPriceRQBuilder.getWPNCRequest(flight, true, false, true);
                break;
            }
            case HBF2: {
                req = AfsAirPriceRQBuilder.getWPNCRequest(flight, true, false, false);
                break;
            }
            case LAF2: {
                req = AfsAirPriceRQBuilder.getWPNCRequest(flight, false, false, false);
                break;
            }
            case LPF1: {
                req = AfsAirPriceRQBuilder.getWPNCRequest(flight, false, true, false);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"AFS type can't be processed with AfsAirPriceRemarkRequestProcessor", (Object[])new Object[]{afsType});
            }
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)req);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirPriceLLSRQ");
    }

    public static OTAAirPriceRQ getWPNCRequest(Flight flight, boolean onlyUnrestrictedFare, boolean includingWithNoSeats, boolean excludingTax) {
        OTAAirPriceRQ request = new OTAAirPriceRQ();
        request.setVersion("2.17.0");
        request.setReturnHostCommand(Boolean.TRUE);
        OTAAirPriceRQ.OptionalQualifiers oq = new OTAAirPriceRQ.OptionalQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers fq = new OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers();
        oq.setFlightQualifiers(fq);
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers pq = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.BargainFinder bf = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.BargainFinder();
        if (includingWithNoSeats) {
            bf.setHistorical(Boolean.TRUE);
        }
        pq.setBargainFinder(bf);
        if (onlyUnrestrictedFare) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.FareOptions fo = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.FareOptions();
            fo.setExcursion(Boolean.TRUE);
            pq.setFareOptions(fo);
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Overrides.NoFareRestrictions nfr = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Overrides.NoFareRestrictions();
            nfr.setInd(true);
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Overrides ov = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Overrides();
            ov.setNoFareRestrictions(nfr);
            pq.setOverrides(ov);
        }
        if (excludingTax) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes taxes = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes();
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes.NoTax noTax = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Taxes.NoTax();
            noTax.setInd(true);
            taxes.setNoTax(noTax);
            pq.setTaxes(taxes);
        }
        oq.setPricingQualifiers(pq);
        request.setOptionalQualifiers(oq);
        return request;
    }
}

