/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation.remarks;

import com.gridnine.xtrip.common.gds.corp.CorporateBookingParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.corp.StatHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.corp.AbstractSabreAFS;
import com.gridnine.xtrip.server.gds.sabre.corp.SabreAFS;
import com.gridnine.xtrip.server.gds.sabre.corp.SabreStatHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class AfsAirPriceRemarkProcessor
extends BaseProcessor {
    boolean isTicketing;
    boolean noGdsRemarks;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.isTicketing = Boolean.parseBoolean(parameters.get("ticketing"));
        this.noGdsRemarks = Boolean.parseBoolean(parameters.get("no_gds_remarks"));
    }

    public void process(MessageContext ctx) throws Exception {
        Double pricing;
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_TYPE);
        switch (afsType) {
            case HBF1: {
                OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
                pricing = AfsAirPriceRemarkProcessor.extractWPNCPricing(afsType, response, true, false, true);
                break;
            }
            case HBF2: {
                OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
                pricing = AfsAirPriceRemarkProcessor.extractWPNCPricing(afsType, response, true, false, false);
                break;
            }
            case LAF2: {
                OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
                pricing = AfsAirPriceRemarkProcessor.extractWPNCPricing(afsType, response, false, false, false);
                break;
            }
            case LPF1: {
                OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
                pricing = AfsAirPriceRemarkProcessor.extractWPNCPricing(afsType, response, false, true, false);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"Unable to process AFS by AfsAirPriceRemarkProcessor", (Object[])new Object[]{afsType});
            }
        }
        if (pricing == null) {
            this.log.warn(afsType + " stat value can't be extracted from the OTA_AirPrice response");
        } else {
            SabreAFS sabreAfs = AbstractSabreAFS.getMandatorySabreAFS(afsType);
            StatisticalData statData = StatHelper.getStatisticalData((MessageContext)ctx);
            sabreAfs.saveValueToMOM(pricing, statData, this.isTicketing);
            if (!this.noGdsRemarks) {
                CorporateBookingParameters params = (CorporateBookingParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_BOOKING_PARAMETERS);
                SabreStatHelper.addRemark(sabreAfs, ctx, params, pricing, this.isTicketing);
            }
        }
    }

    @Deprecated
    public static Double extractWPNCPricing(AFSType afsType, OTAAirPriceRS response, boolean onlyUnrestrictedFare, boolean includingWithNoSeats, boolean excludingTax) {
        String totalFareStr;
        OTAAirPriceRS.PriceQuote.PricedItinerary pi;
        OTAAirPriceRS.PriceQuote pq;
        Double result = null;
        if (response != null && (pq = response.getPriceQuote()) != null && (pi = pq.getPricedItinerary()) != null && StringUtils.isNotEmpty((String)(totalFareStr = pi.getTotalAmount()))) {
            try {
                result = Double.valueOf(totalFareStr);
            }
            catch (NumberFormatException e) {
                throw Xeption.forDeveloper((String)"Non-numeric {0} value from Sabre: {1}", (Object[])new Object[]{afsType.name(), totalFareStr});
            }
        }
        return result;
    }
}

