/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation.remarks;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.corp.AbstractSabreAFS;
import com.gridnine.xtrip.server.gds.sabre.corp.SabreCommandAFS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public final class AfsSabreCommandBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_TYPE);
        SabreCommandAFS afs = AbstractSabreAFS.getSabreCommandAFS(afsType);
        String command = afs.getSabreCommand();
        if (command == null) {
            if (afsType == AFSType.ATF1) {
                command = this.getAtf1SabreCommand(ctx);
            } else {
                throw Xeption.forAdmin((String)"AFS type {0} was passed to AfsSabreCommandRemarkProcessor but doesn't have SabreCommand defined,  check xml settings", (Object[])new Object[]{afsType});
            }
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_REQUEST, (Object)command);
    }

    private String getAtf1SabreCommand(MessageContext ctx) {
        String carrierCode;
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        String string = carrierCode = flight.getCarrier() == null ? null : flight.getCarrier().getCode();
        if (carrierCode == null) {
            throw Xeption.forDeveloper((String)"flight.getCarrier().getCode() is null", (Object[])new Object[]{flight.getCarrier()});
        }
        return "WPA" + carrierCode;
    }
}

