/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation.remarks;

import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.gds.corp.CorporateBookingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public final class FopRemarkProcessor
extends BaseProcessor {
    private boolean optionalCreditCard;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.optionalCreditCard = Boolean.parseBoolean(parameters.get("optional_credit_card"));
    }

    public void process(MessageContext ctx) throws Exception {
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        CorporateBookingParameters params = (CorporateBookingParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_BOOKING_PARAMETERS);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Fop fop = params.getFop();
        if (fop != null) {
            PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark fopRemark = this.buildFopRemarkV2(ctx, fop, (DictionaryReference<Airline>)flight.getCarrier());
            if (fopRemark != null) {
                request.getSpecialReqDetails().getAddRemarkRQ().getFOPRemarkList().add(fopRemark);
            }
        } else {
            this.log.warn("FOP is null for " + flight);
        }
    }

    private PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark buildFopRemarkV2(MessageContext ctx, Fop fop, DictionaryReference<Airline> airlineRef) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        PaymentType paymentType = fop.getType();
        if (paymentType == null) {
            this.log.error("No payment type provided for FOP: " + fop.toString() + ", please fix");
            return null;
        }
        switch (paymentType) {
            case INVOICE: {
                PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark checkRemark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark();
                if ("S7".equals(SabreHelper.getNativeCode((DictionaryReference)flight.getCarrier())) && !StringUtils.isBlank((String)flight.getTripartiteContractDetails().getContractCode())) {
                    checkRemark.setType("INVOICE*" + flight.getTripartiteContractDetails().getContractCode());
                } else {
                    checkRemark.setType("CK");
                }
                return checkRemark;
            }
            case CASH: {
                PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark cashRemark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark();
                cashRemark.setType("CASH");
                return cashRemark;
            }
            case CREDIT_CARD: {
                XMLGregorianCalendar cardExpiryXml;
                Card card = fop.getCard();
                if (card == null) {
                    if (this.optionalCreditCard) {
                        return null;
                    }
                    throw Xeption.forDeveloper((String)"FOP is CREDIT_CARD but no credit card data were provided", (Object[])new Object[0]);
                }
                String cardNumber = card.getNumber();
                Date cardExpirationDate = card.getExpiration();
                Calendar cardExpiration = Calendar.getInstance();
                cardExpiration.setTime(cardExpirationDate);
                int cardExpirationYear = cardExpiration.get(1) % 100;
                int cardExpirationMonth = cardExpiration.get(2) + 1;
                Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineRef);
                Set acceptableCards = airline.getAcceptableCards();
                if (acceptableCards.isEmpty()) {
                    throw Xeption.forAdmin((String)"Credit card type list is not filled for the airline", (Object[])new Object[]{airline.getCode()});
                }
                String cardTypeStr = null;
                for (AirlineCard acceptableCard : acceptableCards) {
                    if (card.getVendor() != acceptableCard.getVendor()) continue;
                    cardTypeStr = acceptableCard.getCode();
                    break;
                }
                if (cardTypeStr == null) {
                    String errorMessage = "Payment card type " + card.getVendor() + " is not accepted by the airline " + airlineRef.getCode();
                    throw Xeption.forEndUser((String)errorMessage, (Object[])new Object[0]);
                }
                try {
                    cardExpiryXml = DatatypeFactory.newInstance().newXMLGregorianCalendar(cardExpirationYear, cardExpirationMonth, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                }
                catch (DatatypeConfigurationException e) {
                    throw Xeption.forDeveloper((String)"Can't add card expiry date", (Throwable)e, (Object[])new Object[0]);
                }
                MaskSensitiveTraceDataHelper.addMaskedPaymentCardNumberValue((MessageContext)ctx, (String)cardNumber);
                MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)cardExpiryXml.toString());
                StringBuilder sb = new StringBuilder(5);
                if (cardExpirationMonth < 10) {
                    sb.append('0');
                }
                sb.append(cardExpirationMonth);
                sb.append('/');
                int lastTwoDigits = cardExpirationYear % 100;
                if (lastTwoDigits < 10) {
                    sb.append('0');
                }
                sb.append(lastTwoDigits);
                MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)sb.toString(), (String)"**/**");
                MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)cardExpiryXml.toString());
                PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark cardRemark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark();
                PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark.CCInfo ccInfo = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark.CCInfo();
                ccInfo.setPaymentCardCode(cardTypeStr);
                ccInfo.setPaymentCardNumber(cardNumber);
                ccInfo.setPaymentCardExpireDate(cardExpiryXml.toString());
                ccInfo.setPaymentCardSuppressApprovalCode(Boolean.TRUE);
                cardRemark.setCCInfo1(ccInfo);
                return cardRemark;
            }
        }
        throw Xeption.forAdmin((String)"FOP {0} is not supported", (Object[])new Object[]{paymentType});
    }

    private PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark buildFopRemark(MessageContext ctx, String fopStr, DictionaryReference<Airline> airlineRef, List<NamedValue> customParameters) {
        PaymentType paymentType = PaymentType.valueOf((String)fopStr);
        if (paymentType != null) {
            switch (paymentType) {
                case INVOICE: {
                    PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark checkRemark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark();
                    checkRemark.setType("CK");
                    return checkRemark;
                }
                case CASH: {
                    PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark cashRemark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark();
                    cashRemark.setType("CASH");
                    return cashRemark;
                }
                case CREDIT_CARD: {
                    String cardInfoText = NamedValueHelper.getValueForName((String)"fop.card", customParameters);
                    if (cardInfoText != null) {
                        XMLGregorianCalendar cardExpiryXml;
                        String cardFinalType;
                        int year;
                        int month;
                        String[] ccData = cardInfoText.split(":");
                        if (ccData.length < 3) {
                            this.log.error("Invalid payment card data");
                            break;
                        }
                        String cardReceivedType = ccData[0];
                        String cardNumber = ccData[1];
                        String[] cardValidityDate = ccData[2].split("/");
                        if (cardValidityDate.length < 2) {
                            this.log.error("Invalid payment card validity info");
                            break;
                        }
                        try {
                            month = Integer.parseInt(cardValidityDate[0]);
                            year = Integer.parseInt(cardValidityDate[1]);
                        }
                        catch (NumberFormatException e) {
                            break;
                        }
                        Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineRef);
                        Set acceptableCards = airline.getAcceptableCards();
                        if (acceptableCards.isEmpty()) {
                            cardFinalType = cardReceivedType;
                        } else {
                            cardFinalType = null;
                            for (AirlineCard acceptableCard : acceptableCards) {
                                CardVendor vendor = acceptableCard.getVendor();
                                if (!vendor.name().equals(cardReceivedType)) continue;
                                cardFinalType = acceptableCard.getCode();
                                break;
                            }
                            if (cardFinalType == null) {
                                this.log.error("Payment card type " + cardReceivedType + " is not accepted for the airline " + airlineRef.getCode() + ", or the dictionary is pre-filled incorrectly");
                                break;
                            }
                        }
                        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark cardRemark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark();
                        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark.CCInfo ccInfo = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.FOPRemark.CCInfo();
                        ccInfo.setPaymentCardCode(cardFinalType);
                        ccInfo.setPaymentCardNumber(cardNumber);
                        MaskSensitiveTraceDataHelper.addMaskedPaymentCardNumberValue((MessageContext)ctx, (String)cardNumber);
                        try {
                            cardExpiryXml = DatatypeFactory.newInstance().newXMLGregorianCalendar(year, month, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        }
                        catch (DatatypeConfigurationException e) {
                            this.log.error("Can't add expiry date: " + e.getMessage());
                            break;
                        }
                        ccInfo.setPaymentCardExpireDate(cardExpiryXml.toString());
                        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)cardExpiryXml.toString());
                        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)(cardValidityDate[0] + "/" + cardValidityDate[1]), (String)"**/**");
                        ccInfo.setPaymentCardSuppressApprovalCode(Boolean.TRUE);
                        cardRemark.setCCInfo1(ccInfo);
                        return cardRemark;
                    }
                    return null;
                }
                default: {
                    this.log.error("FOP is not supported: " + paymentType);
                }
            }
        }
        this.log.error("Sabre FOP wasn't added for " + fopStr + ", please fix");
        return null;
    }
}

