/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation.remarks;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.corp.CorporateBookingParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.server.gds.corp.StatHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.List;
import java.util.Map;

public final class ReasonCodeRemarkProcessor
extends BaseProcessor {
    private boolean noGdsRemarks;
    private boolean optional;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.noGdsRemarks = Boolean.parseBoolean(parameters.get("no_gds_remarks"));
        this.optional = Boolean.parseBoolean(parameters.get("optional"));
    }

    public void process(MessageContext ctx) throws Exception {
        CorporateBookingParameters params = StatHelper.getCorporateBookingParameters((MessageContext)ctx, (boolean)this.optional);
        if (params == null) {
            return;
        }
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        StatisticalData statData = StatHelper.getStatisticalData((MessageContext)ctx);
        Organization client = (Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity();
        List availableReasonCodes = client.getReasonCodes();
        int rkCounter = params.getRkCounter();
        for (ReasonCode chosenReasonCode : params.getReasonCodes()) {
            for (ReasonCode reasonCode : availableReasonCodes) {
                if (!chosenReasonCode.equals((Object)reasonCode)) continue;
                statData.getReasonCodes().add(reasonCode);
                if (this.noGdsRemarks) continue;
                PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
                request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(ReasonCodeRemarkProcessor.createInvoiceRemark("X*RK", rkCounter++, "*AFS*AFS.OR.RSN.CODE*", chosenReasonCode.getName(), "*"));
            }
        }
        params.setRkCounter(rkCounter);
    }

    private static PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark createInvoiceRemark(Object ... objects) {
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE);
        StringBuilder sb = new StringBuilder(64);
        for (Object object : objects) {
            sb.append(object.toString());
        }
        remark.setText(sb.toString());
        return remark;
    }
}

