/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.createReservation.remarks;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.CarTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActions;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class TripartiteContractsHelper {
    static int counter = 1;

    public static List<TripartiteContract> findTripartiteContracts(EntityReference<Organization> orgRef, EntityReference<Organization> mainAgency, TripartiteContractType type) throws ServiceException, Exception {
        ArrayList<TripartiteContract> res = new ArrayList<TripartiteContract>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.contractType.name(), (Object)type));
        if (mainAgency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.agency.name(), (Object)mainAgency.getUid()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)orgRef.getUid()));
        List tempRes = EntityStorage.get().search(TripartiteContractIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        for (TripartiteContractIndex tci : tempRes) {
            EntityReference tcRef = tci.getSource();
            EntityContainer tcCont = EntityStorage.get().resolve(tcRef);
            if (tcCont == null) continue;
            TripartiteContract tc = (TripartiteContract)tcCont.getEntity();
            for (TripartiteContractCustomerInfo tcci : tc.getCustomers()) {
                if (tcci.getCustomer() == null || !tcci.getCustomer().equals(orgRef) || tcci.getStartDate() != null && !tcci.getStartDate().before(new Date()) || tcci.getEndDate() != null && !tcci.getEndDate().after(new Date())) continue;
                res.add(tc);
            }
        }
        return res;
    }

    public static void addTripartiteContractRemarks(EntityReference<Organization> orgRef, TripartiteContractType type, Map<String, List<String>> linesMap, List<Message> messages) {
        List tourCodeValues;
        List accCodeValues;
        LinkedHashMap<TripartiteContractsLineDescription, List<String>> remarks = new LinkedHashMap<TripartiteContractsLineDescription, List<String>>();
        String serviceCode = "";
        switch (type) {
            case AVIA: {
                serviceCode = ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.A);
                break;
            }
            case HOTEL: {
                serviceCode = ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.H);
                break;
            }
            case CAR: {
                serviceCode = ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.C);
            }
        }
        TripartiteContractsLineDescription corpCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription accCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription tourCodeKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        TripartiteContractsLineDescription publicFareDiscountKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 40);
        try {
            for (TripartiteContract tctr : TripartiteContractsHelper.findTripartiteContracts(orgRef, null, type)) {
                TripartiteContractsHelper.updateTripartiteContractRemarks(remarks, tctr, serviceCode, corpCodeKey, accCodeKey, tourCodeKey, publicFareDiscountKey, messages);
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(TripartiteContractsHelper.class).error("unable to find tripartite contracts", e);
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Unable to find tripartite contracts", (Throwable)e, (Object[])new Object[0]));
            return;
        }
        List corpCodeValues = (List)remarks.remove(corpCodeKey);
        if (corpCodeValues != null) {
            remarks.put(corpCodeKey, corpCodeValues);
        }
        if ((accCodeValues = (List)remarks.remove(accCodeKey)) != null) {
            remarks.put(accCodeKey, accCodeValues);
        }
        if ((tourCodeValues = (List)remarks.remove(tourCodeKey)) != null) {
            remarks.put(tourCodeKey, tourCodeValues);
        }
        for (Map.Entry<TripartiteContractsLineDescription, List<String>> entry : remarks.entrySet()) {
            TripartiteContractsLineDescription description = entry.getKey();
            ArrayList<String> splitedRemarks = new ArrayList<String>();
            StringBuilder currentString = new StringBuilder();
            int codesCountInLine = 0;
            String prefix = description.getServiceCode() + '\u00a5' + description.getActionCode() + (!TextUtil.isBlank((String)description.getActionCode()) ? description.getDelimiterAfterPrefix() : "");
            int treshold = 57 - prefix.length() - 2;
            for (String item : entry.getValue()) {
                if (TextUtil.isBlank((String)item)) continue;
                if (codesCountInLine >= description.getMaxCodesPerLine() || currentString.length() + item.length() > treshold) {
                    ArrayList partsOfLongLine = new ArrayList();
                    if (item.length() > 57 - prefix.length() - 2) {
                        ProfileSynchronizationUtil.split((String)item, (int)treshold, partsOfLongLine);
                        item = null;
                    }
                    if (currentString.length() > 0) {
                        splitedRemarks.add(currentString.toString());
                        currentString = new StringBuilder();
                        codesCountInLine = 0;
                    }
                    for (String part : partsOfLongLine) {
                        splitedRemarks.add(part);
                    }
                }
                if (currentString.length() > 0) {
                    currentString.append(description.getDelimiterBetweenCodes());
                }
                if (item == null) continue;
                currentString.append(item);
                ++codesCountInLine;
            }
            if (currentString.length() > 0) {
                splitedRemarks.add(currentString.toString());
            }
            if (splitedRemarks.size() > description.getMaxLinesPerProfile()) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Tripartite search error", (Object[])new Object[]{description.getActionCode()}));
                return;
            }
            for (String line : splitedRemarks) {
                StringBuilder sb = new StringBuilder(prefix);
                sb.append(line);
                sb.append(!TextUtil.isBlank((String)description.getActionCode()) && "*".equals(description.getDelimiterAfterPrefix()) ? "*" : "");
                List<String> list = linesMap.get(description.getServiceCode());
                if (list == null) {
                    list = new ArrayList<String>();
                    linesMap.put(description.getServiceCode(), list);
                }
                list.add(sb.toString().toUpperCase());
            }
        }
    }

    private static void updateTripartiteContractRemarks(Map<TripartiteContractsLineDescription, List<String>> remarks, TripartiteContract contract, String serviceCode, TripartiteContractsLineDescription corpCodeKey, TripartiteContractsLineDescription accCodeKey, TripartiteContractsLineDescription tourCodeKey, TripartiteContractsLineDescription publicFareDiscountKey, List<Message> messages) {
        if (contract.getType() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Contract type has no message specified", (Object[])new Object[]{contract.getName()}));
            return;
        }
        String autoRemarkSuppliers = "";
        ArrayList<String> airlines = new ArrayList<String>();
        switch (contract.getType()) {
            case AVIA: {
                for (DictionaryReference airline : contract.getAviaVendorData().getAirlines()) {
                    autoRemarkSuppliers = autoRemarkSuppliers + (autoRemarkSuppliers.length() > 0 ? "/" : "") + airline.getCode();
                    airlines.add(airline.getCode());
                }
                if (!TextUtil.isBlank((String)autoRemarkSuppliers)) break;
                for (DictionaryReference allianceRef : contract.getAviaVendorData().getAlliances()) {
                    autoRemarkSuppliers = autoRemarkSuppliers + (autoRemarkSuppliers.length() > 0 ? "/" : "") + allianceRef.getCode();
                    airlines.add(allianceRef.getCode());
                }
                break;
            }
            case HOTEL: {
                for (DictionaryReference brand : contract.getHotelVendorData().getBrands()) {
                    if (brand == null) continue;
                    autoRemarkSuppliers = autoRemarkSuppliers + (autoRemarkSuppliers.length() > 0 ? "/" : "") + brand.getCode();
                }
                if (contract.getHotelVendorData().getBrands().size() != 0) break;
                autoRemarkSuppliers = "GLOBAL RATES";
                break;
            }
            case CAR: {
                for (DictionaryReference brand : contract.getCarVendorData().getSuppliers()) {
                    if (brand == null) continue;
                    autoRemarkSuppliers = autoRemarkSuppliers + (autoRemarkSuppliers.length() > 0 ? "/" : "") + brand.getCode();
                }
                break;
            }
        }
        if (TextUtil.isBlank((String)serviceCode)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"U", (Object[])new Object[]{contract.getName()}));
            return;
        }
        String corporatePrefix = ProfileSynchronizationUtil.getLineServiceTypeStringForRemark((SabreProfileLineServiceType)ProfileSynchronizationUtil.getLineServiceTypeFromString((String)serviceCode)) + " CORPORATE DEALS / ";
        TripartiteContractsLineDescription autoRemarkKey = new TripartiteContractsLineDescription(serviceCode, "", "", 1, 50);
        if (!remarks.containsKey(autoRemarkKey)) {
            remarks.put(autoRemarkKey, new ArrayList());
        }
        if (contract.getRuleSet() == null || contract.getRuleSet().getRules() == null) {
            return;
        }
        for (RuleSettings rs : contract.getRuleSet().getRules()) {
            if (rs.getTarget() == null || rs.getPeriodBegin() != null && rs.getPeriodBegin().after(new Date()) || rs.getPeriodEnd() != null && rs.getPeriodEnd().before(new Date())) continue;
            StringBuilder sb = new StringBuilder();
            ArrayList<String> fareBasisLines = new ArrayList<String>();
            int fareBasisLimit = 57 - "CORP.DISC".length() - 8;
            for (RuleRestriction restr : rs.getRestrictions()) {
                String[] codes;
                if (restr.getProperty() == null || !TextUtil.isSame((String)restr.getProperty().getId(), (String)"FARE_BASIS") || !(restr.getValue() instanceof String) || !Conditions.EQUALS.equals((Object)restr.getCondition())) continue;
                for (String code : codes = ((String)restr.getValue()).split(",")) {
                    if ((code = code.trim()).startsWith("!")) continue;
                    if (sb.length() + code.length() + 1 >= fareBasisLimit) {
                        fareBasisLines.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    sb.append((sb.length() > 0 ? Character.valueOf('\u00a5') : "") + code);
                }
            }
            if (sb.length() > 0) {
                fareBasisLines.add(sb.toString());
            }
            for (RuleResult rr : rs.getResults()) {
                List<String> list;
                TripartiteContractsLineDescription key;
                TripartitePublicFareDiscount discount;
                String actionCode = null;
                int maxCodesPerLine = 0;
                int maxLinesPerProfile = 0;
                boolean needCorporateSection = false;
                boolean needTourCodePrefix = false;
                boolean isAccCode = false;
                TripartiteContractsLineDescription specialKeyCode = null;
                if (AviaTripartiteContractActions.AVIA_CORPORATE_ID == rr.getAction()) {
                    actionCode = "CORP.ID";
                    maxCodesPerLine = 4;
                    maxLinesPerProfile = 2;
                    isAccCode = true;
                    specialKeyCode = corpCodeKey;
                } else if (AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE == rr.getAction()) {
                    actionCode = "AIR.ACCT.CODE";
                    maxCodesPerLine = 10;
                    maxLinesPerProfile = 4;
                    isAccCode = true;
                    specialKeyCode = accCodeKey;
                } else if (AviaTripartiteContractActions.AVIA_FREE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    needCorporateSection = true;
                } else if (AviaTripartiteContractActions.AVIA_TEMPLATE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 99;
                    needCorporateSection = true;
                } else if (AviaTripartiteContractActions.AVIA_TOUR_CODE == rr.getAction()) {
                    actionCode = "AIR.TOUR.CODE";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    needTourCodePrefix = true;
                    specialKeyCode = tourCodeKey;
                } else if (AviaTripartiteContractActions.AVIA_PUBLIC_FARE_DISCOUNT == rr.getAction()) {
                    actionCode = "CORP.DISC";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    specialKeyCode = publicFareDiscountKey;
                } else if (HotelTripartiteContractActions.HOTEL_CORPORATE_ID == rr.getAction()) {
                    actionCode = "HOTL.CO";
                    maxCodesPerLine = 4;
                    maxLinesPerProfile = 1;
                    isAccCode = true;
                    specialKeyCode = corpCodeKey;
                } else if (HotelTripartiteContractActions.HOTEL_DISCOUNT_NUMBER == rr.getAction()) {
                    actionCode = "CD.NUMB";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    isAccCode = true;
                    specialKeyCode = accCodeKey;
                } else if (HotelTripartiteContractActions.HOTEL_FREE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 98;
                    needCorporateSection = true;
                } else if (HotelTripartiteContractActions.HOTEL_TEMPLATE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 97;
                    needCorporateSection = true;
                } else if (CarTripartiteContractActions.CAR_DISCOUNT_NUMBER == rr.getAction()) {
                    actionCode = "CAR CD.NUMB";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 100;
                    isAccCode = true;
                    specialKeyCode = corpCodeKey;
                } else if (CarTripartiteContractActions.CAR_FREE_REMARK == rr.getAction()) {
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 96;
                    needCorporateSection = true;
                } else {
                    if (CarTripartiteContractActions.CAR_TEMPLATE_REMARK != rr.getAction()) continue;
                    actionCode = "";
                    maxCodesPerLine = 1;
                    maxLinesPerProfile = 95;
                    needCorporateSection = true;
                }
                List values = new ArrayList<String>();
                boolean needPublicFareDiscountPrefix = false;
                if (rr.getValue() instanceof SabreRemarkResult) {
                    values.add(((SabreRemarkResult)rr.getValue()).getTemplate());
                } else if (rr.getValue() instanceof String || rr.getValue() instanceof Iterable) {
                    values = RulesHelper.toStringCollection((Object)rr.getValue());
                } else if (rr.getValue() instanceof TripartitePublicFareDiscount && (discount = (TripartitePublicFareDiscount)rr.getValue()).getValue() != null && !fareBasisLines.isEmpty()) {
                    values.addAll(airlines);
                    needPublicFareDiscountPrefix = true;
                }
                if (values.isEmpty()) continue;
                if (isAccCode && !TextUtil.isBlank((String)autoRemarkSuppliers) && !HotelTripartiteContractActions.HOTEL_DISCOUNT_NUMBER.equals((Object)rr.getAction())) {
                    String autoRemark = corporatePrefix + autoRemarkSuppliers + " - " + (String)values.get(0);
                    List<String> autoList = remarks.get(autoRemarkKey);
                    autoList.add(autoRemark);
                    isAccCode = false;
                }
                if (!TextUtil.isBlank((String)actionCode)) {
                    key = specialKeyCode != null ? specialKeyCode : corpCodeKey;
                    key.setActionCode(actionCode);
                    key.setMaxCodesPerLine(maxCodesPerLine);
                    key.setMaxLinesPerProfile(maxLinesPerProfile);
                    if ("AIR.ACCT.CODE".equals(actionCode)) {
                        key.setDelimiterAfterPrefix("/");
                        key.setDelimiterBetweenCodes("*");
                    }
                } else {
                    key = new TripartiteContractsLineDescription(serviceCode, "", actionCode, maxCodesPerLine, maxLinesPerProfile);
                }
                if (needTourCodePrefix) {
                    key.setDelimiterAfterPrefix("/");
                }
                if ((list = remarks.get(key)) == null) {
                    list = new ArrayList<String>();
                    remarks.put(key, list);
                }
                for (String v : values) {
                    List<String> splittedLines = new ArrayList();
                    if (needCorporateSection) {
                        splittedLines = ProfileSynchronizationUtil.advancedPrepareRemarkForSabre((String)v, (int)50, (String)"", (String)ProfileSynchronizationUtil.getLineServiceTypeStringForRemark((SabreProfileLineServiceType)ProfileSynchronizationUtil.getLineServiceTypeFromString((String)serviceCode)), (String)" CORPORATE DEALS /", (String)"", (boolean)false, (boolean)true);
                    } else if (needTourCodePrefix) {
                        Object tourCodesStr = new StringBuilder();
                        ArrayList<String> listOfTourCodes = new ArrayList<String>();
                        if (contract.getAviaVendorData().getAlliances() != null && contract.getAviaVendorData().getAlliances().size() > 0) {
                            StringBuilder alliancesStr = new StringBuilder();
                            for (String a : airlines) {
                                alliancesStr.append(alliancesStr.length() > 0 ? "/" + a : a);
                            }
                            airlines.clear();
                            airlines.add(alliancesStr.toString());
                        }
                        for (String a : airlines) {
                            String s = a + "-" + (String)ProfileSynchronizationConstants.CalculatiionIndicator2String.get(TripartiteContractsHelper.getCalculationIndicator(contract)) + v;
                            if (((StringBuilder)tourCodesStr).length() + s.length() < 53 - "AIR.TOUR.CODE".length()) {
                                ((StringBuilder)tourCodesStr).append((((StringBuilder)tourCodesStr).length() > 0 ? "*" : "") + s);
                                continue;
                            }
                            listOfTourCodes.add(((StringBuilder)tourCodesStr).toString());
                            tourCodesStr = new StringBuilder(s);
                        }
                        listOfTourCodes.add(((StringBuilder)tourCodesStr).toString());
                        splittedLines.addAll(listOfTourCodes);
                    } else if (needPublicFareDiscountPrefix) {
                        for (String fb : fareBasisLines) {
                            String line = ProfileSynchronizationUtil.prepareRemarkForSabre((String)(v + (!TextUtil.isBlank((String)fb) ? Character.valueOf('\u00a5') : "") + fb), (String)"", (String)"", (boolean)false);
                            splittedLines.add(line.trim());
                        }
                    } else {
                        splittedLines = ProfileSynchronizationUtil.advancedPrepareRemarkForSabre((String)v, (int)50, (String)"", (String)"", (String)"", (String)"", (boolean)false, (boolean)true);
                        ArrayList<String> trimLines = new ArrayList<String>();
                        for (String s : splittedLines) {
                            trimLines.add(s.trim());
                        }
                        splittedLines = trimLines;
                    }
                    list.addAll(splittedLines);
                }
            }
        }
    }

    public static TripartiteContractCalculationIndicatorType getCalculationIndicator(TripartiteContract contract) {
        if (contract == null || contract.getRuleSet() == null) {
            return null;
        }
        for (RuleSettings rs : contract.getRuleSet().getRules()) {
            for (RuleResult rr : rs.getResults()) {
                if (rr.getAction() != AviaTripartiteContractActions.AVIA_CALCULATION_INDICATOR && rr.getAction() != CarTripartiteContractActions.CAR_CALCULATION_INDICATOR && rr.getAction() != HotelTripartiteContractActions.HOTEL_CALCULATION_INDICATOR) continue;
                return (TripartiteContractCalculationIndicatorType)rr.getValue();
            }
        }
        return null;
    }

    static final class TripartiteContractsLineDescription {
        private final int num;
        private final String supplierCode;
        private String actionCode;
        private int maxCodesPerLine;
        private int maxLinesPerProfile;
        private final String serviceCode;
        private String delimiterAfterPrefix;
        private String delimiterBetweenCodes;

        TripartiteContractsLineDescription(String service, String supplier, String action, int maxCodes, int maxLines) {
            this.serviceCode = service;
            this.supplierCode = supplier;
            this.actionCode = action;
            this.maxCodesPerLine = maxCodes;
            this.maxLinesPerProfile = maxLines;
            this.delimiterAfterPrefix = "*";
            this.delimiterBetweenCodes = String.valueOf('\u00a5');
            this.num = counter++;
        }

        String getSupplierCode() {
            return this.supplierCode;
        }

        String getActionCode() {
            return this.actionCode;
        }

        int getMaxCodesPerLine() {
            return this.maxCodesPerLine;
        }

        int getMaxLinesPerProfile() {
            return this.maxLinesPerProfile;
        }

        String getServiceCode() {
            return this.serviceCode;
        }

        public String getDelimiterAfterPrefix() {
            return this.delimiterAfterPrefix;
        }

        public String getDelimiterBetweenCodes() {
            return this.delimiterBetweenCodes;
        }

        int getNum() {
            return this.num;
        }

        void setActionCode(String value) {
            this.actionCode = value;
        }

        void setDelimiterAfterPrefix(String value) {
            this.delimiterAfterPrefix = value;
        }

        void setDelimiterBetweenCodes(String value) {
            this.delimiterBetweenCodes = value;
        }

        void setMaxCodesPerLine(int value) {
            this.maxCodesPerLine = value;
        }

        void setMaxLinesPerProfile(int value) {
            this.maxLinesPerProfile = value;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof TripartiteContractsLineDescription) {
                TripartiteContractsLineDescription descr2 = (TripartiteContractsLineDescription)o2;
                return TextUtil.isSame((String)this.serviceCode, (String)descr2.serviceCode) && TextUtil.isSame((String)this.supplierCode, (String)descr2.supplierCode) && TextUtil.isSame((String)this.actionCode, (String)descr2.actionCode) && this.maxCodesPerLine == descr2.maxCodesPerLine && this.maxLinesPerProfile == descr2.maxLinesPerProfile && this.num == descr2.num;
            }
            return false;
        }

        public int hashCode() {
            return (this.serviceCode != null ? this.serviceCode.hashCode() : 0) + (this.supplierCode != null ? this.supplierCode.hashCode() : 0) + (this.actionCode != null ? this.actionCode.hashCode() : 0) + this.maxCodesPerLine + this.maxLinesPerProfile + this.num;
        }
    }
}

