/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.dailySalesReport;

import com.gridnine.xtrip.common.gds.model.DailySalesReportParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class DQBCommandBuilder
extends BaseProcessor {
    private final FastDateFormat df = FastDateFormat.getInstance((String)"ddMMMyy", (Locale)Locale.ENGLISH);

    public void process(MessageContext ctx) throws Exception {
        DailySalesReportParameters parameters = (DailySalesReportParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_PARAMETERS);
        StringBuilder sb = new StringBuilder("DQB*");
        sb.append(this.df.format(parameters.getDate()));
        if (!StringUtils.isBlank((String)parameters.getQualifier())) {
            sb.append('\u00a5');
            sb.append(parameters.getQualifier());
            if (parameters.getCarrier() != null) {
                sb.append("/");
                sb.append(SabreHelper.getNativeCode((DictionaryReference)parameters.getCarrier()));
            }
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_REQUEST, (Object)sb.toString());
    }
}

