/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.dailySalesReport;

import com.gridnine.xtrip.common.gds.model.DailySalesReportItem;
import com.gridnine.xtrip.common.gds.model.DailySalesReportParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DQBOutputParser
extends BaseProcessor {
    private final Set<Pattern> patterns = new HashSet<Pattern>();

    public DQBOutputParser() {
        this.patterns.add(Pattern.compile("PNR\\-(?<pnr>[^ ]+)(?<passenger>.*)ETR.*\r?\n[ ]*(?<ticketNumbers>[\\d\\-]+)[ ]+\\d*[ ]+[^ ]+[ ]+\\d+[ ]+(?<fopCode>[^ ]+)[ ]+[^ ]+[ ]+(?<price>[\\d\\.]+).*", 8));
        this.patterns.add(Pattern.compile("PNR\\-(?<pnr>[^ ]+)(?<passenger>.*)AGT SINE.*\r?\nCOMMISSION AMOUNT\\-[ ]*[\\d\\.]*[ ]+TICKET AMOUNT - [^ ]+[ ]+(?<price>[\\d\\.]+)(?<fopCode>.{2})[ ]*\r?\n[ ]*(?<ticketNumbers>[\\d\\-]+).*", 8));
    }

    public void process(MessageContext ctx) throws Exception {
        DailySalesReportParameters parameters = (DailySalesReportParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_PARAMETERS);
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        HashSet<DailySalesReportItem> items = (HashSet<DailySalesReportItem>)ctx.getObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_ITEMS);
        if (items == null) {
            items = new HashSet<DailySalesReportItem>();
            ctx.putObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_ITEMS, items);
        }
        if (this.hasData(response)) {
            Matcher m = this.getMatcher(response);
            while (m.find()) {
                if (parameters.getPnr() != null && !parameters.getPnr().equals(m.group("pnr"))) continue;
                String line = m.group();
                DailySalesReportItem item = new DailySalesReportItem();
                String passenger = m.group("passenger").trim();
                if (line.trim().endsWith("V")) {
                    if (!parameters.isIncludeVoided()) continue;
                    item.setStatus(ProductStatus.VOID);
                } else {
                    item.setStatus(ProductStatus.SELL);
                }
                item.setCategory(ProductCategory.AIR);
                item.setPassenger(passenger);
                String ticketNumbers = m.group("ticketNumbers");
                if (ticketNumbers.contains("-")) {
                    item.setTicketNumber(ticketNumbers.substring(0, ticketNumbers.indexOf(45)));
                    String[] numbers = ticketNumbers.substring(ticketNumbers.length() - 5).split("-");
                    int conjCount = Integer.parseInt(numbers[1]) - Integer.parseInt(numbers[0]) + 1;
                    if (conjCount < 0) {
                        conjCount += 100;
                    }
                    item.setConjCount(conjCount);
                } else {
                    item.setTicketNumber(ticketNumbers);
                }
                item.setFopCode(m.group("fopCode"));
                item.setPrice(new BigDecimal(m.group("price")));
                items.add(item);
            }
        }
    }

    private Matcher getMatcher(String response) {
        Matcher result = null;
        for (Pattern pattern : this.patterns) {
            Matcher m = pattern.matcher(response);
            if (!m.find()) continue;
            if (result == null) {
                m.reset();
                result = m;
                continue;
            }
            throw Xeption.forDeveloper((String)"multiple patterns matched", (Object[])new Object[0]);
        }
        if (result == null) {
            throw Xeption.forDeveloper((String)"no patterns matched", (Object[])new Object[0]);
        }
        return result;
    }

    private boolean hasData(String response) {
        return !response.contains("NO AUDIT TRAIL EXISTS FOR DATE REQUESTED");
    }
}

