/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.dailySalesReport;

import com.gridnine.sabre.dqb.tktas._DSFop;
import com.gridnine.sabre.dqb.tktas._DSPayment;
import com.gridnine.sabre.dqb.tktas._DSReport;
import com.gridnine.sabre.dqb.tktas._DSTransaction;
import com.gridnine.sabre.dqb.tktas._DailySalesSummaryRS;
import com.gridnine.xtrip.common.gds.model.DailySalesReportItem;
import com.gridnine.xtrip.common.gds.model.DailySalesReportParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.HashSet;

public class DailySalesSummaryRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DailySalesReportParameters parameters = (DailySalesReportParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_PARAMETERS);
        _DailySalesSummaryRS response = (_DailySalesSummaryRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        HashSet<DailySalesReportItem> items = (HashSet<DailySalesReportItem>)ctx.getObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_ITEMS);
        if (items == null) {
            items = new HashSet<DailySalesReportItem>();
            ctx.putObject((Enum)IBusGdsContextKeys.DAILY_SALES_REPORT_ITEMS, items);
        }
        if (response.getDailySalesReportList() != null) {
            for (_DSReport dailySalesReport : response.getDailySalesReportList()) {
                if (dailySalesReport.getTransactionList() == null) continue;
                block11: for (_DSTransaction transaction : dailySalesReport.getTransactionList()) {
                    if (parameters.getPnr() != null && !parameters.getPnr().equals(transaction.getPnrLocator())) continue;
                    DailySalesReportItem item = new DailySalesReportItem();
                    switch (transaction.getDocumentDetails().getTransactionCode()) {
                        case "VOID": {
                            if (!parameters.isIncludeVoided()) continue block11;
                            item.setStatus(ProductStatus.VOID);
                            break;
                        }
                        case "SALE": {
                            if ("V".equals(transaction.getDocumentDetails().getDocumentStatusCode())) {
                                if (!parameters.isIncludeVoided()) continue block11;
                                item.setStatus(ProductStatus.VOID);
                                break;
                            }
                            item.setStatus(ProductStatus.SELL);
                            break;
                        }
                        case "RFND": {
                            item.setStatus(ProductStatus.REFUND);
                            break;
                        }
                        default: {
                            throw Xeption.forDeveloper((String)"unexpected transaction code {0}", (Object[])new Object[]{transaction.getDocumentDetails().getTransactionCode()});
                        }
                    }
                    item.setCategory(ProductCategory.AIR);
                    item.setPassenger(transaction.getPassengerName());
                    String ticketNumbers = transaction.getDocumentDetails().getDocumentNumber();
                    if (ticketNumbers.contains("-")) {
                        item.setTicketNumber(ticketNumbers.substring(0, ticketNumbers.indexOf(45)));
                        String[] numbers = ticketNumbers.substring(ticketNumbers.length() - 5).split("-");
                        int conjCount = Integer.parseInt(numbers[1]) - Integer.parseInt(numbers[0]) + 1;
                        if (conjCount < 0) {
                            conjCount += 100;
                        }
                        item.setConjCount(conjCount);
                    } else {
                        item.setTicketNumber(ticketNumbers);
                    }
                    String lastConjunctiveDocumentNumber = transaction.getDocumentDetails().getLastConjunctiveDocumentNumber();
                    item.setLastConjunctiveDocNumber(lastConjunctiveDocumentNumber);
                    if (transaction.getPaymentList().size() > 1) {
                        throw Xeption.forDeveloper((String)"multiple Payment elements: {0}", (Object[])new Object[]{Integer.toString(transaction.getPaymentList().size())});
                    }
                    if (((_DSFop)transaction.getPaymentList().get(0)).getDocumentPayment().getPaymentDetailList().size() > 1) {
                        throw Xeption.forDeveloper((String)"multiple PaymentDetail elements: {0}", (Object[])new Object[]{Integer.toString(((_DSFop)transaction.getPaymentList().get(0)).getDocumentPayment().getPaymentDetailList().size())});
                    }
                    item.setFopCode(((_DSPayment.PaymentDetail)((_DSFop)transaction.getPaymentList().get(0)).getDocumentPayment().getPaymentDetailList().get(0)).getFop());
                    item.setPrice(((_DSFop)transaction.getPaymentList().get(0)).getDocumentPayment().getPaymentTotal());
                    item.setDate(transaction.getTransactionDateTime());
                    if (transaction.getCommission() != null) {
                        if (transaction.getCommission().getAmount() != null) {
                            item.setCommissionAmount(transaction.getCommission().getAmount());
                        }
                        if (transaction.getCommission().getPercent() != null) {
                            item.setCommissionPercent(new BigDecimal(transaction.getCommission().getPercent()));
                        }
                    }
                    item.setCurrencyCode(((_DSFop)transaction.getPaymentList().get(0)).getCurrencyCode().getString());
                    items.add(item);
                }
            }
        }
    }
}

