/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.db.update;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.Actions;
import com.gridnine.xtrip.common.gds.rules.FilteringCategories;
import com.gridnine.xtrip.common.gds.rules.GdsPropertiesProvider;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.rules.standard.GdsNamePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class BaseSabrePrinterTypeMigrationHandler<E extends BaseEntity, I extends EntityIndex<E>>
implements SetupUpdateHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(Element command) throws Exception {
        Set<SabreGdsAccountWrapper> wrappers = BaseSabrePrinterTypeMigrationHandler.getWrappers();
        SearchQuery sq = this.buildSearchQuery();
        for (EntityIndex index : EntityStorage.get().search(this.getIndexClass(), sq).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
            if (!this.migrate(ctr, wrappers)) continue;
            ctr.getVersionInfo().setDataSource("BaseSabrePrinterTypeMigrationHandler");
            EntityStorage.get().save(ctr, true);
        }
    }

    private static Set<SabreGdsAccountWrapper> getWrappers() {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.SABRE));
        return EntityStorage.get().search(GdsAccountIndex.class, sq).getData().stream().map(GdsAccountIndex::getSource).map(x$0 -> new SabreGdsAccountWrapper((EntityReference)x$0)).collect(Collectors.toSet());
    }

    private boolean migrate(EntityContainer<E> ctr, Set<SabreGdsAccountWrapper> wrappers) {
        this.log.info("Migrating entity {} {}", (Object)ctr.getUid(), (Object)ctr.getEntity().getClass().getName());
        BaseEntity entity = ctr.getEntity();
        boolean changed = false;
        Date now = new Date();
        RuleSet ruleSet = this.getRuleSet(entity);
        if (ruleSet != null && ruleSet.getRules() != null) {
            for (int i = 0; i < ruleSet.getRules().size(); ++i) {
                try {
                    RuleSettings rule = (RuleSettings)ruleSet.getRules().get(i);
                    if (rule.getTarget() != Targets.GDS_PARAMETERS_EX) {
                        this.log.debug("rule {} skipped, because it is not GDS_PARAMETERS_EX", (Object)i);
                        continue;
                    }
                    if (rule.getFilteringCategory() != FilteringCategories.TICKETING_SETTINGS) {
                        this.log.debug("rule {} skipped, because it is not TICKETING_SETTINGS", (Object)i);
                        continue;
                    }
                    if (rule.getPeriodEnd() != null && rule.getPeriodEnd().before(now)) {
                        this.log.debug("rule {} skipped, because it is expired", (Object)i);
                        continue;
                    }
                    String blankOwner = BaseSabrePrinterTypeMigrationHandler.getBlankOwner(rule);
                    if (blankOwner == null) {
                        this.log.debug("rule {} skipped, because it has no blank owner", (Object)i);
                        continue;
                    }
                    EntityContainer blankOwnerCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)blankOwner);
                    if (blankOwnerCtr == null) {
                        this.log.error("rule {} skipped, because it has invalid blank owner {}", (Object)i, (Object)blankOwner);
                        continue;
                    }
                    Set<String> applicableCountries = BaseSabrePrinterTypeMigrationHandler.getApplicableCountries(rule, wrappers);
                    if (applicableCountries.isEmpty()) {
                        this.log.debug("rule {} skipped, because it has no applicable sabre countries", (Object)i);
                        continue;
                    }
                    ValueHolder errorHolder = new ValueHolder();
                    Set printerTypes = applicableCountries.stream().map(country -> BaseSabrePrinterTypeMigrationHandler.getPrinterType(country, (Organization)blankOwnerCtr.getEntity(), (ValueHolder<String>)errorHolder)).collect(Collectors.toSet());
                    if (printerTypes.size() > 1) {
                        this.log.error("rule {} skipped, because it has ambiguous printer type {}", (Object)i, (Object)String.join((CharSequence)", ", printerTypes));
                        continue;
                    }
                    String printerType = (String)printerTypes.iterator().next();
                    if (printerType == null) {
                        this.log.error("rule {} skipped, because we failed to determine printer type: {}", (Object)i, errorHolder.getValue());
                        continue;
                    }
                    RuleResult result = new RuleResult();
                    result.setAction((RuleAction)Actions.SABRE_PRINTER_TYPE);
                    result.setValue((Object)printerType);
                    rule.getResults().add(result);
                    this.log.info("rule {} migrated successfully with printer type {}", (Object)i, (Object)printerType);
                    changed = true;
                    continue;
                }
                catch (Exception ex) {
                    this.log.error("rule {} skipped, because an exception occurred", (Object)i, (Object)ex);
                }
            }
        }
        return changed;
    }

    private static String getBlankOwner(RuleSettings rule) {
        return rule.getResults().stream().filter(rr -> rr.getAction() == Actions.BLANK_OWNER).map(RuleResult::getValue).findFirst().orElse(null);
    }

    private static Set<String> getApplicableCountries(RuleSettings rule, Set<SabreGdsAccountWrapper> wrappers) {
        List restrictions = rule.getRestrictions().stream().filter(rr -> rr.getProperty() == Properties.GDS_NAME || rr.getProperty() == com.gridnine.xtrip.common.gds.rules.Properties.GDS_ACCOUNT).collect(Collectors.toList());
        return wrappers.stream().filter(w -> restrictions.stream().allMatch(rr -> rr.getProperty().match(w, rr.getCondition(), rr.getValue()))).map(SabreGdsAccountWrapper::getCountry).collect(Collectors.toSet());
    }

    private static String getPrinterType(String country, Organization blankOwner, ValueHolder<String> errorHolder) {
        switch (country) {
            case "RU": {
                switch (blankOwner.getCode()) {
                    case "BSP": {
                        return "RU";
                    }
                    case "\u04281": {
                        return "1T";
                    }
                }
                switch (SabreHelper.getNativeCode((DictionaryReference)blankOwner.getAirline())) {
                    case "SU": {
                        return "1R";
                    }
                    case "S7": 
                    case "DV": 
                    case "U6": 
                    case "B2": {
                        return "1Y";
                    }
                }
                errorHolder.setValue((Object)("unexpected blank owner " + blankOwner.getCode()));
                return null;
            }
            case "AM": {
                switch (SabreHelper.getNativeCode((DictionaryReference)blankOwner.getAirline())) {
                    case "DV": 
                    case "AF": 
                    case "OS": 
                    case "DL": 
                    case "KL": 
                    case "U6": {
                        return "1Y";
                    }
                    case "SU": 
                    case "B2": {
                        return "1R";
                    }
                }
                errorHolder.setValue((Object)("unexpected blank owner " + blankOwner.getCode()));
                return null;
            }
            case "KZ": {
                switch (blankOwner.getCode()) {
                    case "BSP": 
                    case "\u041a\u0413\u0410": {
                        return "KZ";
                    }
                }
                switch (SabreHelper.getNativeCode((DictionaryReference)blankOwner.getAirline())) {
                    case "B2": 
                    case "DV": 
                    case "Z9": {
                        return "1Y";
                    }
                }
                errorHolder.setValue((Object)("unexpected blank owner " + blankOwner.getCode()));
                return null;
            }
            case "UA": 
            case "GE": 
            case "BG": 
            case "DE": {
                switch (blankOwner.getCode()) {
                    case "BSP": {
                        return "AT";
                    }
                }
                errorHolder.setValue((Object)("unexpected blank owner " + blankOwner.getCode()));
                return null;
            }
            case "IL": {
                switch (blankOwner.getCode()) {
                    case "BSP": {
                        return "IL";
                    }
                }
                errorHolder.setValue((Object)("unexpected blank owner " + blankOwner.getCode()));
                return null;
            }
            case "AZ": {
                switch (blankOwner.getCode()) {
                    case "BSP": {
                        return "AT";
                    }
                }
                switch (SabreHelper.getNativeCode((DictionaryReference)blankOwner.getAirline())) {
                    case "J2": {
                        return "1Y";
                    }
                }
                errorHolder.setValue((Object)("unexpected blank owner " + blankOwner.getCode()));
                return null;
            }
        }
        errorHolder.setValue((Object)("unexpected country " + country));
        return null;
    }

    protected abstract SearchQuery buildSearchQuery();

    protected abstract Class<I> getIndexClass();

    protected abstract RuleSet getRuleSet(E var1);

    private static class SabreGdsAccountWrapper
    implements GdsPropertiesProvider,
    GdsNamePropertiesProvider {
        private final EntityReference<SabreGdsAccount> account;
        private final String country;

        private SabreGdsAccountWrapper(EntityReference<? extends BaseGdsAccount> account) {
            this.account = account;
            this.country = SabreServerHelper.getCountry((EntityContainer<SabreGdsAccount>)EntityStorage.get().resolve(this.account));
        }

        public EntityReference<SabreGdsAccount> getGdsAccount() {
            return this.account;
        }

        public String getGdsName() {
            return GdsName.SABRE.name();
        }

        public String getCountry() {
            return this.country;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SabreGdsAccountWrapper that = (SabreGdsAccountWrapper)o;
            return Objects.equals(this.account, that.account);
        }

        public int hashCode() {
            return Objects.hashCode(this.account);
        }
    }
}

