/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.db.update;

import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.w3c.dom.Element;

public class UpdateScheduledTasksToUseGdsAccountUpdateHandler
implements SetupUpdateHandler {
    private final Set<String> adapterIds = new HashSet<String>();
    private final Set<String> routeIds = new HashSet<String>();

    public UpdateScheduledTasksToUseGdsAccountUpdateHandler() {
        this.adapterIds.add("gds:sabre:airline-alliances:airline-alliances");
        this.adapterIds.add("gds:sabre:class-of-service:class-of-service");
        this.adapterIds.add("gds:sabre:currency-rates:currency-rates");
        this.adapterIds.add("gds:sabre:fqtv-agreements:fqtv-agreements");
        this.adapterIds.add("gds:sabre:reactivate-iur-queue:reactivate-iur-queue");
        this.routeIds.add("gds:sabre:update-aircraft-dict");
    }

    public void execute(Element command) throws Exception {
        SearchQuery query = new SearchQuery();
        List idxs = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, query).getData();
        for (ScheduledTaskSettingsIndex idx : idxs) {
            boolean change = false;
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            Set dataMap = ((ScheduledTaskSettings)ctr.getEntity()).getDataMap();
            if ("com.gridnine.xtrip.server.model.tasks.standard.IBusInvokerTask".equals(((ScheduledTaskSettings)ctr.getEntity()).getJobClass()) && dataMap != null) {
                String adapterId = NamedValueHelper.getValueForName((String)"adapterId", (Collection)dataMap);
                if (adapterId != null && this.adapterIds.contains(adapterId)) {
                    change = true;
                } else {
                    String routeId = NamedValueHelper.getValueForName((String)"routeId", (Collection)dataMap);
                    if (routeId != null && this.routeIds.contains(routeId)) {
                        change = true;
                    }
                }
            }
            if (!change) continue;
            NamedValue nvAccount = NamedValueHelper.getNamedValueForName((String)"account", (Collection)dataMap);
            NamedValue nvAddress = NamedValueHelper.getNamedValueForName((String)"address", (Collection)dataMap);
            NamedValue nvPassword = NamedValueHelper.getNamedValueForName((String)"password", (Collection)dataMap);
            NamedValue nvPcc = NamedValueHelper.getNamedValueForName((String)"pcc", (Collection)dataMap);
            String account = null;
            String address = null;
            String password = null;
            String pcc = null;
            if (nvAccount != null) {
                account = nvAccount.getValue();
                dataMap.remove(nvAccount);
            }
            if (nvAddress != null) {
                address = nvAddress.getValue();
                dataMap.remove(nvAddress);
            }
            if (nvPassword != null) {
                password = nvPassword.getValue();
                dataMap.remove(nvPassword);
            }
            if (nvPcc != null) {
                pcc = nvPcc.getValue();
                dataMap.remove(nvPcc);
            }
            EntityContainer<SabreGdsAccount> accountCtr = this.getOrCreateSabreGdsAccount(account, address, password, pcc, ((ScheduledTaskSettings)ctr.getEntity()).getName());
            dataMap.add(NamedValueHelper.namedValue((String)"accountContainerUid", (String)accountCtr.getUid()));
            ctr.getVersionInfo().setDataSource("UpdateScheduledTasksToUseGdsAccountUpdateHandler");
            EntityStorage.get().save(ctr, true);
        }
    }

    private EntityContainer<SabreGdsAccount> getOrCreateSabreGdsAccount(String account, String address, String password, String pcc, String taskName) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.SABRE));
        List idxs = EntityStorage.get().search(GdsAccountIndex.class, query).getData();
        for (GdsAccountIndex idx : idxs) {
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            if (!Objects.equals(((SabreGdsAccount)ctr.getEntity()).getAccount(), account) || !Objects.equals(((SabreGdsAccount)ctr.getEntity()).getAddress(), address) || !Objects.equals(((SabreGdsAccount)ctr.getEntity()).getPassword(), password) || !Objects.equals(((SabreGdsAccount)ctr.getEntity()).getPrimaryPCC(), account)) continue;
            return ctr;
        }
        EntityContainer ctr = new EntityContainer(SabreGdsAccount.class);
        ((SabreGdsAccount)ctr.getEntity()).setGds(GdsName.SABRE);
        ((SabreGdsAccount)ctr.getEntity()).setAccount(account);
        ((SabreGdsAccount)ctr.getEntity()).setAddress(address);
        ((SabreGdsAccount)ctr.getEntity()).setPassword(password);
        ((SabreGdsAccount)ctr.getEntity()).setPrimaryPCC(pcc);
        ((SabreGdsAccount)ctr.getEntity()).setName(String.format("Sabre %s %s", Optional.ofNullable(address).orElse("").contains("cert") ? "CERT" : "PROD", taskName));
        ctr.getVersionInfo().setDataSource("UpdateScheduledTasksToUseGdsAccountUpdateHandler");
        EntityStorage.get().save(ctr, true);
        return ctr;
    }
}

