/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.OTAAirAvailRQParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirAvailRQ;
import org.apache.commons.lang.time.FastDateFormat;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OTAAirAvailRQBuilder
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"MM-dd");
    private static final DateTimeFormatter TIME_WINDOW_FORMATTER = DateTimeFormat.forPattern((String)"HH:mm");

    public void process(MessageContext ctx) throws Exception {
        OTAAirAvailRQParameters parameters = (OTAAirAvailRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.OTA_AIR_AVAIL_RQ_PARAMETERS);
        OTAAirAvailRQ request = this.buildRequest(parameters);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirAvailLLSRQ");
    }

    private OTAAirAvailRQ buildRequest(OTAAirAvailRQParameters parameters) {
        OTAAirAvailRQ request = new OTAAirAvailRQ();
        request.setVersion("2.4.0");
        request.setReturnHostCommand(Boolean.TRUE);
        OTAAirAvailRQ.OptionalQualifiers oq = new OTAAirAvailRQ.OptionalQualifiers();
        request.setOptionalQualifiers(oq);
        if (parameters.isAdditionalAvailability()) {
            OTAAirAvailRQ.OptionalQualifiers.AdditionalAvailability aa = new OTAAirAvailRQ.OptionalQualifiers.AdditionalAvailability();
            aa.setInd(Boolean.TRUE);
            if (parameters.isDirectAccess()) {
                aa.setDirectAccess(Boolean.TRUE);
            }
            oq.setAdditionalAvailability(aa);
        } else {
            OTAAirAvailRQ.OriginDestinationInformation odi = new OTAAirAvailRQ.OriginDestinationInformation();
            odi.setFlightSegmentOriginLocation(SabreHelper.getNativeCode((DictionaryReference)parameters.getRouteSegment().getLocationBegin()));
            odi.setFlightSegmentDestinationLocation(SabreHelper.getNativeCode((DictionaryReference)parameters.getRouteSegment().getLocationEnd()));
            odi.setFlightSegmentDepartureDateTime(DF.format(parameters.getRouteSegment().getDate()));
            if (parameters.getRouteSegment().getDepartureTimeBegin() != null) {
                OTAAirAvailRQ.OptionalQualifiers.TimeQualifiers tq = new OTAAirAvailRQ.OptionalQualifiers.TimeQualifiers();
                OTAAirAvailRQ.OptionalQualifiers.TimeQualifiers.DepartureTime time = new OTAAirAvailRQ.OptionalQualifiers.TimeQualifiers.DepartureTime();
                LocalTime tb = LocalTime.fromMillisOfDay((long)((long)parameters.getRouteSegment().getDepartureTimeBegin().intValue() * 60000L));
                time.setWindowAfter(TIME_WINDOW_FORMATTER.print((ReadablePartial)tb));
                if (parameters.getRouteSegment().getDepartureTimeEnd() != null) {
                    LocalTime te = LocalTime.fromMillisOfDay((long)((long)parameters.getRouteSegment().getDepartureTimeEnd().intValue() * 60000L));
                    time.setWindowBefore(TIME_WINDOW_FORMATTER.print((ReadablePartial)te));
                }
                tq.setDepartureTime(time);
                oq.setTimeQualifiers(tq);
            } else if (parameters.getRouteSegment().getDepartureTimeEnd() != null) {
                throw Xeption.forEndUser((String)"\u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u0432\u0435\u0440\u0445\u043d\u0435\u0439 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430 \u0431\u0435\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u043d\u0438\u0436\u043d\u0435\u0439 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
            }
            if (parameters.getAirline() != null || parameters.isDirectOnly()) {
                OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers fq = new OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers();
                if (parameters.isDirectOnly()) {
                    fq.setDirectOnly(Boolean.TRUE);
                }
                if (parameters.getAirline() != null) {
                    OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs vp = new OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs();
                    if (parameters.isDirectAccess()) {
                        vp.setDirectAccess(Boolean.TRUE);
                    }
                    OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs.Airline airline = new OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs.Airline();
                    airline.setCode(SabreHelper.getNativeCode((DictionaryReference)parameters.getAirline()));
                    vp.getAirlineList().add(airline);
                    fq.setVendorPrefs(vp);
                }
                oq.setFlightQualifiers(fq);
            }
            request.setOriginDestinationInformation(odi);
        }
        return request;
    }
}

