/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FlightLeg;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatsDetails;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicator;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirAvailRS;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class OTAAirAvailRSParser
extends BaseProcessor {
    private static final String DF_PATTERN = "MM-dd'T'HH:mm";

    public void process(MessageContext ctx) throws Exception {
        OTAAirAvailRS response = (OTAAirAvailRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List<FlightLeg> flightLegs = this.parseResponse(response);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_LEGS, flightLegs);
    }

    private List<FlightLeg> parseResponse(OTAAirAvailRS response) throws Exception {
        ArrayList<FlightLeg> result = new ArrayList<FlightLeg>();
        if (response.getOriginDestinationOptions() != null && response.getOriginDestinationOptions().getOriginDestinationOptionList() != null) {
            for (OTAAirAvailRS.OriginDestinationOptions.OriginDestinationOption odi : response.getOriginDestinationOptions().getOriginDestinationOptionList()) {
                FlightLeg flightLeg = new FlightLeg();
                boolean starting = true;
                for (OTAAirAvailRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment sabreFs : odi.getFlightSegmentList()) {
                    Set items;
                    FlightSegment fs = new FlightSegment();
                    fs.setStarting(starting);
                    starting = false;
                    fs.setLocationBegin(SabreHelper.resolveNativeCode(GeoLocation.class, (String)sabreFs.getOriginLocation().getLocationCode()));
                    fs.setLocationEnd(SabreHelper.resolveNativeCode(GeoLocation.class, (String)sabreFs.getDestinationLocation().getLocationCode()));
                    fs.setDateBegin(Date.from(SabreHelper.parseDateTimeWithoutYear((String)sabreFs.getDepartureDateTime(), (String)DF_PATTERN, (ZoneId)SabreHelper.getDateTimeZone((String)sabreFs.getOriginLocation().getLocationCode())).toInstant()));
                    fs.setDateEnd(Date.from(SabreHelper.parseDateTimeWithoutYear((String)sabreFs.getArrivalDateTime(), (String)DF_PATTERN, (ZoneId)SabreHelper.getDateTimeZone((String)sabreFs.getDestinationLocation().getLocationCode())).toInstant()));
                    fs.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)sabreFs.getMarketingAirline().getCode()));
                    if (sabreFs.getOperatingAirline() != null) {
                        DictionaryReference<Airline> airlineRef;
                        String code = sabreFs.getOperatingAirline().getCode();
                        if ("**".equals(code)) {
                            List textList = sabreFs.getDisclosureAirline().getTextList();
                            String spellVariant = SabreServerHelper.getSpellVariantFrom(textList.toArray(new String[textList.size()]));
                            airlineRef = SabreServerHelper.findOrCreateAirlineBySpellVariant(spellVariant);
                        } else {
                            airlineRef = SabreHelper.resolveNativeCode(Airline.class, (String)code);
                        }
                        fs.setOperatingAirline((DictionaryReference)airlineRef);
                    } else {
                        fs.setOperatingAirline(SabreHelper.resolveNativeCode(Airline.class, (String)sabreFs.getMarketingAirline().getCode()));
                    }
                    fs.setFlightNumber(sabreFs.getFlightNumber().replaceAll("^0+", ""));
                    fs.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)sabreFs.getEquipment().getAirEquipType()));
                    fs.setStops(Integer.parseInt(sabreFs.getStopQuantity()));
                    fs.setGds(GdsName.SABRE);
                    for (OTAAirAvailRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.BookingClassAvail bca : sabreFs.getBookingClassAvailList()) {
                        SeatsDetails seatsDetails = new SeatsDetails();
                        seatsDetails.setBookingClass(bca.getResBookDesigCode());
                        seatsDetails.setServiceClass(FlightHelper.findClassOfService((DictionaryReference)fs.getAirline(), (DictionaryReference)fs.getOperatingAirline(), (String)bca.getResBookDesigCode(), (boolean)DictHelper.isInternational((DictionaryReference)fs.getLocationBegin(), (DictionaryReference)fs.getLocationEnd())));
                        Integer seats = SabreHelper.parseAvailability((String)bca.getAvailability());
                        if (seats != null) {
                            seatsDetails.setAvailableCount(seats.intValue());
                        }
                        fs.getSeatsDetails().add(seatsDetails);
                    }
                    if (sabreFs.getMealList() != null && sabreFs.getMealList().size() > 0 && !(items = DictHelper.getDictionaryItemsByCode(MealServiceIndicator.class, (String)((OTAAirAvailRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.Meal)sabreFs.getMealList().get(0)).getMealCode())).isEmpty()) {
                        fs.setMealServiceIndicator((DictionaryReference)((MealServiceIndicator)items.iterator().next()).toReference());
                    }
                    flightLeg.getSegments().add(fs);
                }
                result.add(flightLeg);
            }
        }
        return result;
    }
}

