/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator.log;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.model.AirBookRQParameters;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.emulator.log.EmulatorLog;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.stream.Collectors;

public class LogBookSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        if (EmulatorLog.isEnabled()) {
            SabreSession session = (SabreSession)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
            AirBookRQParameters parameters = (AirBookRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AIR_BOOK_RQ_PARAMETERS);
            StringBuilder sb = new StringBuilder("book-segments: route=");
            sb.append(FlightHelper.toIdentifiableString((List)parameters.getSegments()));
            sb.append(", bookingClasses=");
            sb.append(parameters.getSegments().stream().map(FlightSegment::getBookingClass).collect(Collectors.joining(",")));
            sb.append(", totalSeatCount=");
            sb.append(parameters.getTotalSeatCount());
            EmulatorLog.log(sb.toString(), session);
        }
    }
}

