/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator.log;

import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.model.OTAAirAvailRQParameters;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.emulator.log.EmulatorLog;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.time.FastDateFormat;

public class LogSearchSegmentsProcessor
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public void process(MessageContext ctx) throws Exception {
        if (EmulatorLog.isEnabled()) {
            SabreSession session = (SabreSession)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
            OTAAirAvailRQParameters parameters = (OTAAirAvailRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.OTA_AIR_AVAIL_RQ_PARAMETERS);
            StringBuilder sb = new StringBuilder("search-segments: route=");
            sb.append(parameters.getRouteSegment().getLocationBegin().getCode());
            sb.append('-');
            sb.append(parameters.getRouteSegment().getLocationEnd().getCode());
            sb.append('@');
            sb.append(DF.format(parameters.getRouteSegment().getDate()));
            sb.append(", additionalAvailability=");
            sb.append(parameters.isAdditionalAvailability());
            sb.append(", airline=");
            sb.append(parameters.getAirline() != null ? parameters.getAirline().getCode() : "null");
            sb.append(", directAccess=");
            sb.append(parameters.isDirectAccess());
            sb.append(", directOnly=");
            sb.append(parameters.isDirectOnly());
            EmulatorLog.log(sb.toString(), session);
        }
    }
}

