/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator.rollback;

import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.sabrexml.OTACancelRQ;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class EmulatorRollbackOTACancelRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType modifiedResponse = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        GetReservationRSType originalResponse = (GetReservationRSType)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.EMULATOR_ROLLBACK_DATA);
        List modifiedSeg = GetReservationHelper.getAirs(modifiedResponse).stream().map(AirType::getSequence).collect(Collectors.toList());
        List originalSeg = GetReservationHelper.getAirs(originalResponse).stream().map(AirType::getSequence).collect(Collectors.toList());
        modifiedSeg.removeAll(originalSeg);
        OTACancelRQ request = new OTACancelRQ();
        request.setVersion("2.0.3");
        request.setReturnHostCommand(Boolean.TRUE);
        OTACancelRQ.Segment seg = new OTACancelRQ.Segment();
        seg.setNumber(new BigInteger(String.valueOf(modifiedSeg.get(0))));
        if (modifiedSeg.size() > 1) {
            seg.setEndNumber(new BigInteger(String.valueOf(modifiedSeg.get(modifiedSeg.size() - 1))));
        }
        request.getSegmentList().add(seg);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_CancelLLSRQ");
    }
}

