/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator.rules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightLeg;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightLegPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class ApplyRuleActionsToFlightLegProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Collection flightLegs = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_LEGS);
        RuleProxy proxy = (RuleProxy)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULE_PROXY);
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        FlightLeg flightLeg = ((FlightLegPropertySet)proxy.getPropertySet()).getLeg();
        Flight fakeFlight = this.buildFakeFlight(flightLeg);
        if (isSaveRulesTraces) {
            for (String ruleUid : proxy.getAppliedRules()) {
                RuleSettings rs = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                if (rs == null) continue;
                builder.traceFlightLogic((BaseEntity)fakeFlight, MessageType.MESSAGE, String.format("rule %s was applied: %s", rs.getName(), rs.getRestrictionsInfoNoHtml()));
            }
        }
        if (((GDSParametersActions)proxy.getActionSet()).isExcludeFromResult()) {
            if (isSaveRulesTraces) {
                builder.traceFlightLogic((BaseEntity)fakeFlight, MessageType.MESSAGE, "flightSegment was excluded from result due tot rules restriction");
            }
            flightLegs.remove(flightLeg);
        }
        if (isSaveRulesTraces) {
            builder.traceFlightLogic((BaseEntity)fakeFlight, MessageType.MESSAGE, String.format("subsidized tariff was set to %s", Boolean.toString(((GDSParametersActions)proxy.getActionSet()).isSubsidizedTariff())));
        }
    }

    private Flight buildFakeFlight(FlightLeg flightLeg) {
        Flight result = new Flight();
        FlightSegmentTariff fst = new FlightSegmentTariff();
        fst.getSegments().addAll(flightLeg.getSegments());
        result.getSegmentTariffs().add(fst);
        return result;
    }
}

