/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.emulator.rules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightLeg;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightLegPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;

public class FlightLegRuleProxyBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightLeg leg = (FlightLeg)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_LEG);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean trace = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        RuleProxy<FlightLegPropertySet, GDSParametersActions> proxy = this.createProxy(leg, salesContext, (EntityContainer<BaseGdsAccount>)accountCtr, trace);
        ArrayList<RuleProxy<FlightLegPropertySet, GDSParametersActions>> proxies = (ArrayList<RuleProxy<FlightLegPropertySet, GDSParametersActions>>)ctx.getObject((Enum)IBusGdsContextKeys.RULE_PROXIES);
        if (proxies == null) {
            proxies = new ArrayList<RuleProxy<FlightLegPropertySet, GDSParametersActions>>();
            ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXIES, proxies);
        }
        proxies.add(proxy);
    }

    private RuleProxy<FlightLegPropertySet, GDSParametersActions> createProxy(FlightLeg leg, SalesContext salesContext, EntityContainer<BaseGdsAccount> accountCtr, boolean proxyTracerEnabled) {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(Targets.GDS_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new FlightLegPropertySet(leg, proxy, salesContext, accountCtr.toReference()));
        proxy.setActionSet((Object)new GDSParametersActions());
        return proxy;
    }
}

