/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.endTransaction;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.endTransaction.EndTransactionRQParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.EndTransactionRQ;

public class EndTransactionRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EndTransactionRQParameters parameters = (EndTransactionRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.END_TRANSACTION_RQ_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        EndTransactionRQ request = this.buildRequest(parameters, (SabreGdsAccount)accountCtr.getEntity());
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"EndTransactionLLSRQ");
    }

    private EndTransactionRQ buildRequest(EndTransactionRQParameters parameters, SabreGdsAccount account) {
        EndTransactionRQ request = new EndTransactionRQ();
        request.setVersion("2.1.0");
        request.setReturnHostCommand(Boolean.TRUE);
        if (parameters.getMode() != EndTransactionRQParameters.Mode.END_ONLY) {
            EndTransactionRQ.Source source = new EndTransactionRQ.Source();
            source.setReceivedFrom(account.getTransactionExecutor());
            request.setSource(source);
        }
        if (parameters.getMode() != EndTransactionRQParameters.Mode.SIGN_ONLY) {
            EndTransactionRQ.EndTransaction et = new EndTransactionRQ.EndTransaction();
            et.setInd(true);
            if (parameters.isEmail()) {
                EndTransactionRQ.EndTransaction.Email email = new EndTransactionRQ.EndTransaction.Email();
                email.setInd(true);
                EndTransactionRQ.EndTransaction.Email.ETicket eticket = new EndTransactionRQ.EndTransaction.Email.ETicket();
                eticket.setInd(true);
                if (parameters.isPdf()) {
                    EndTransactionRQ.EndTransaction.Email.ETicket.PDF pdf = new EndTransactionRQ.EndTransaction.Email.ETicket.PDF();
                    pdf.setInd(true);
                    eticket.setPDF1(pdf);
                }
                email.setETicket(eticket);
                if (parameters.isN00()) {
                    EndTransactionRQ.EndTransaction.Email.PersonName pn = new EndTransactionRQ.EndTransaction.Email.PersonName();
                    pn.setNameNumber("0.0");
                    email.setPersonName(pn);
                }
                et.setEmail(email);
            }
            request.setEndTransaction(et);
        }
        return request;
    }
}

