/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.fareInfo;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AirPriceRqParametersForFareInfoOnlyProvider
extends BaseTargetsProvider<AirPriceRQParameters> {
    public Collection<AirPriceRQParameters> getTargets(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SpecialTariff specialTariff = reservation.getSpecialTariff() != null ? (SpecialTariff)EntityStorage.get().resolve(reservation.getSpecialTariff()).getEntity() : null;
        ImmutableListMultimap productsByType = Multimaps.index((Iterable)GDSHelper.getProducts((Reservation)reservation), (Function)new Function<Product, String>(){

            public String apply(Product prod) {
                return SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType());
            }
        });
        ArrayList types = new ArrayList(productsByType.keySet());
        Collections.sort(types);
        ArrayList<AirPriceRQParameters> result = new ArrayList<AirPriceRQParameters>();
        for (List atomicTypes : Lists.partition(types, (int)4)) {
            AirPriceRQParameters parameters = new AirPriceRQParameters();
            ArrayList<Product> atomicProducts = new ArrayList<Product>();
            for (String atomicType : atomicTypes) {
                for (Product prod : productsByType.get((Object)atomicType)) {
                    atomicProducts.add(prod);
                }
            }
            Product anyProduct = (Product)atomicProducts.get(0);
            parameters.setGdsAccount(reservation.getGdsNameInfo().getOnlineGdsAccount());
            if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
                parameters.getAccountCodes().add(reservation.getAccountCode());
            }
            parameters.setCorporateId(reservation.getCorporateId());
            parameters.setCarrier(anyProduct.getCarrier());
            parameters.setGdsCurrencyCode(anyProduct.getGdsCurrency());
            parameters.setCommission(SabreHelper.getTotalVendorCommissionForSabre((Product)anyProduct));
            for (String atomicType : atomicTypes) {
                parameters.getPassengerTypes().add(new MiscUtil.Pair((Object)atomicType, (Object)productsByType.get((Object)atomicType).size()));
            }
            for (Product atomicProduct : atomicProducts) {
                parameters.getNameNumbers().add(atomicProduct.getGdsId());
            }
            if (specialTariff != null) {
                parameters.setResidentCountry(specialTariff.getResidentCountry());
            }
            if (SabreHelper.isTchBlankOwner((EntityReference)anyProduct.getBlankOwnerRef())) {
                parameters.setValidationMethod("TCH");
            }
            result.add(parameters);
        }
        return result;
    }
}

