/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.fareInfo;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRQ;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AirPriceWithAlternativePricingForFareInfoOnlyRQBuilder
extends BaseProcessor {
    private boolean penaltyInfo;

    public void configure(Map<String, String> parameters) {
        this.penaltyInfo = MiscUtil.isTrue((String)parameters.get("penalty-info"));
    }

    public void process(MessageContext ctx) throws Exception {
        AirPriceRQParameters parameters = (AirPriceRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        OTAAirPriceRQ request = this.buildRequest(parameters, (SabreGdsAccount)accountCtr.getEntity());
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirPriceLLSRQ");
    }

    private OTAAirPriceRQ buildRequest(AirPriceRQParameters parameters, SabreGdsAccount account) {
        OTAAirPriceRQ request = new OTAAirPriceRQ();
        request.setVersion("2.17.0");
        request.setReturnHostCommand(Boolean.TRUE);
        request.setPriceRequestInformationAlternativePricing(Boolean.TRUE);
        OTAAirPriceRQ.OptionalQualifiers oq = new OTAAirPriceRQ.OptionalQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers fq = new OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs vp = new OTAAirPriceRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs();
        vp.setAirline(SabreHelper.getNativeCode((DictionaryReference)parameters.getCarrier()));
        fq.setVendorPrefs(vp);
        oq.setFlightQualifiers(fq);
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers pq = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers();
        if (!parameters.getAccountCodes().isEmpty()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Account acc = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Account();
            acc.getCodeList().addAll(parameters.getAccountCodes());
            pq.setAccount(acc);
        }
        if (!StringUtils.isBlank((String)parameters.getCorporateId())) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Corporate corporate = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Corporate();
            corporate.getIDList().add(parameters.getCorporateId());
            pq.setCorporate(corporate);
        }
        if (parameters.getResidentCountry() != null) {
            pq.setPassengerStatus(String.format("RY/%s", SabreHelper.getNativeCode((DictionaryReference)parameters.getResidentCountry())));
        }
        for (MiscUtil.Pair passengerType : parameters.getPassengerTypes()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.PassengerType pt = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.PassengerType();
            pt.setCode((String)passengerType.getFirst());
            if (passengerType.getSecond() != null) {
                pt.setQuantity(((Integer)passengerType.getSecond()).toString());
            } else {
                pt.setQuantity("");
            }
            pq.getPassengerTypeList().add(pt);
        }
        for (String nameNumber : parameters.getNameNumbers()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.NameSelect ns = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.NameSelect();
            ns.setNameNumber(nameNumber);
            pq.getNameSelectList().add(ns);
        }
        if (this.penaltyInfo) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty sp = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty();
            sp.setAdditionalInfo(Boolean.TRUE);
            pq.setSpecificPenalty(sp);
        }
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing ap = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides o = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides.MatchNoMatch mnm = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides.MatchNoMatch();
        mnm.setInd(Boolean.TRUE);
        o.setMatchNoMatch(mnm);
        ap.setOverrides(o);
        pq.setAlternativePricing(ap);
        oq.setPricingQualifiers(pq);
        request.setOptionalQualifiers(oq);
        return request;
    }
}

