/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.fareInfo;

import com.google.common.collect.Lists;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FlightAirPriceRqParametersForFareInfoOnlyProvider
extends BaseTargetsProvider<AirPriceRQParameters> {
    public Collection<AirPriceRQParameters> getTargets(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        GdsReservationCreationParameters gdsReservationCreationParameters = (GdsReservationCreationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Map nameNumbers = (Map)ctx.getObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        EntityReference specialTariffRef = flight.getSpecialTariff();
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Comparator<SeatPreferences> spComparator = new Comparator<SeatPreferences>(){

            @Override
            public int compare(SeatPreferences sp1, SeatPreferences sp2) {
                String pt1 = SabreHelper.getNativeCode((DictionaryReference)sp1.getPassengerType());
                String pt2 = SabreHelper.getNativeCode((DictionaryReference)sp2.getPassengerType());
                return MiscUtil.compare((Comparable)((Object)pt1), (Comparable)((Object)pt2));
            }
        };
        ArrayList<AirPriceRQParameters> result = new ArrayList<AirPriceRQParameters>();
        ArrayList spsList = new ArrayList(flight.getSeats());
        Collections.sort(spsList, spComparator);
        for (List atomicSps : Lists.partition(spsList, (int)4)) {
            AirPriceRQParameters parameters = new AirPriceRQParameters();
            parameters.setGdsAccount(flight.getGdsAccount());
            if (!StringUtils.isBlank((String)flight.getAccountCode())) {
                parameters.getAccountCodes().add(flight.getAccountCode());
            }
            parameters.setCorporateId(flight.getCorporateId());
            if (gdsParameters.getValidatingCarrier() != null) {
                parameters.setCarrier(gdsParameters.getValidatingCarrier());
            } else {
                parameters.setCarrier(flight.getCarrier());
            }
            parameters.setGdsCurrencyCode(flight.getGdsCurrencyCode());
            for (SeatPreferences atomicSp : atomicSps) {
                parameters.getPassengerTypes().add(new MiscUtil.Pair((Object)SabreHelper.getNativeCode((DictionaryReference)atomicSp.getPassengerType()), (Object)atomicSp.getCount()));
                if (gdsReservationCreationParameters == null || nameNumbers == null) continue;
                for (GdsTraveller gdsTraveller : gdsReservationCreationParameters.getGdsTravellers()) {
                    if (!MiscUtil.equals((Object)atomicSp.getPassengerType(), (Object)gdsTraveller.getPassengerType())) continue;
                    parameters.getNameNumbers().add(nameNumbers.get(gdsTraveller.getTravellerUid()));
                }
            }
            if (specialTariffRef != null) {
                SpecialTariff specialTariff = (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity();
                parameters.setResidentCountry(specialTariff.getResidentCountry());
            }
            if (SabreHelper.isTchBlankOwner((EntityReference)flight.getBlankOwner())) {
                parameters.setValidationMethod("TCH");
            }
            result.add(parameters);
        }
        if (result.size() > 1) {
            for (AirPriceRQParameters parameters : result) {
                parameters.setIncomplete(true);
            }
        }
        return result;
    }
}

