/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.fareInfo;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.util.List;

public class FlightAirPriceWithAlternativePricingForPenaltiesInfoOnlyRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info : response.getPriceQuote().getPricedItinerary().getAirItineraryPricingInfoList()) {
            if (!FlightAirPriceWithAlternativePricingForPenaltiesInfoOnlyRSParser.matches(info, flight)) continue;
            flight.getPenaltiesInfos().put(SabreHelper.resolveNativeCode(PassengerType.class, (String)info.getPassengerTypeQuantity().getCode()), AirPriceHelper.parsePenaltiesInfo(info));
        }
    }

    private static boolean matches(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info, Flight flight) {
        DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)info.getPassengerTypeQuantity().getCode());
        List segs = FlightHelper.getSegments((Flight)flight);
        List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.FareCalculationBreakdown> fcbs = AirPriceHelper.getValidFareCalculationBreakdownList(info);
        for (int i = 0; i < segs.size(); ++i) {
            FlightSegment seg = (FlightSegment)segs.get(i);
            FareInfo fi = FlightAirPriceWithAlternativePricingForPenaltiesInfoOnlyRSParser.getFareInfo(seg, (DictionaryReference<PassengerType>)passengerType);
            OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.FareCalculationBreakdown fcb = fcbs.get(i);
            if (fi.getFareBasis().equals(fcb.getFareBasis().getCode())) continue;
            return false;
        }
        return true;
    }

    private static FareInfo getFareInfo(FlightSegment seg, DictionaryReference<PassengerType> passengerType) {
        for (FareInfo fi : seg.getFareInfos()) {
            if (!fi.getPassengerType().equals(passengerType)) continue;
            return fi;
        }
        return null;
    }
}

