/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.gdsNameInfo;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class SabreReservationGdsNameInfoTest
extends ModelTestBase {
    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        metaRegistry.register(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/midoffice/model-basic-midoffice.xml")));
    }

    @Test
    public void test() throws Exception {
        SabreGdsAccount gdsAccount = new SabreGdsAccount();
        gdsAccount.setGds(GdsName.SABRE);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)gdsAccount, (String)"52ec07ca-074a-4c69-a8bb-e9c5dc35e13a"), true);
        Reservation reservation = (Reservation)this.loadXSerializable("ReservationGdsNameInfoRenamerTest_RESERVATION.xml", Reservation.class);
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        Assert.assertEquals((Object)"52ec07ca-074a-4c69-a8bb-e9c5dc35e13a", (Object)gdsNameInfo.getOnlineGdsAccount().getUid());
        Assert.assertEquals((Object)GdsName.SABRE, (Object)gdsNameInfo.getRulesGdsName());
        Assert.assertEquals((Object)GdsName.SABRE, (Object)gdsNameInfo.getStatisticsGdsName());
        Assert.assertEquals((long)1L, (long)gdsNameInfo.getSystemInfos().size());
        ReservationSystemInfo systemInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0);
        Assert.assertEquals((Object)GdsName.SABRE, (Object)systemInfo.getGdsName());
        Assert.assertEquals((Object)"A12", (Object)systemInfo.getBookingAgentDutyCode());
        Assert.assertEquals((Object)"ABCD", (Object)systemInfo.getBookingPcc());
        Assert.assertEquals((long)1L, (long)systemInfo.getRecordLocators().size());
        RecordLocatorInfo rli = (RecordLocatorInfo)systemInfo.getRecordLocators().get(0);
        Assert.assertEquals((Object)RecordLocatorType.DEFAULT, (Object)rli.getType());
        Assert.assertEquals((Object)"MFJCDP", (Object)rli.getRecordLocator());
        Assert.assertTrue((boolean)rli.isDisplay());
        Assert.assertEquals((Object)"MFJCDP", (Object)SabreHelper.getRecordLocator((Reservation)reservation));
    }
}

