/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getAncillaryFees;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.merch.ancillary.offer.v03.GetAncillaryOffersRQ;
import com.sabre.services.merch.ancillary.offer.v03.GetAncillaryOffersService;
import com.sabre.services.merch.fare.v03.FareBreakAssociation;
import com.sabre.services.merch.fare.v03.FareInfo;
import com.sabre.services.merch.itinerary.v03.PassengerSegment;
import com.sabre.services.merch.itinerary.v03.Segment;
import com.sabre.services.merch.passenger.v03.Passenger;
import com.sabre.services.merch.request.v03.RequestType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class GetAncillaryOffersRQBuilder
extends BaseProcessor {
    private static final String passengerIdPrefix = "pax_";
    private static final String flightIdPrefix = "flight_";
    private static final String segmentIdPrefix = "seg_";
    private static final String requestMode = "booking";
    private static final String fareIdPrefix = "fare_";

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        List segments = FlightHelper.getSegments((Flight)flight);
        List passengersTypes = flight.getSeats().stream().map(SeatPreferences::getPassengerType).collect(Collectors.toList());
        GetAncillaryOffersRQ request = new GetAncillaryOffersRQ();
        request.setRequestType(RequestType.PAYLOAD);
        request.setRequestMode(requestMode);
        GetAncillaryOffersRQ.QueryByItinerary queryByItinerary = new GetAncillaryOffersRQ.QueryByItinerary();
        queryByItinerary.getSegment().addAll(this.getRequestSegmentsList(segments));
        request.setQueryByItinerary(queryByItinerary);
        int fareInfoIndex = 0;
        FareInfo fareInfo = null;
        int passengerIndex = 0;
        for (int i = 0; i < passengersTypes.size(); ++i) {
            if (DictHelper.isInfantPassengerType((DictionaryReference)((DictionaryReference)passengersTypes.get(i)))) continue;
            GetAncillaryOffersRQ.QueryByItinerary.QueryPassengerItinerary qpi = new GetAncillaryOffersRQ.QueryByItinerary.QueryPassengerItinerary();
            Passenger passenger = new Passenger();
            passenger.setId(passengerIdPrefix + ++passengerIndex);
            passenger.setType(SabreHelper.getNativeCode((DictionaryReference)((DictionaryReference)passengersTypes.get(i))));
            qpi.setPassenger(passenger);
            GetAncillaryOffersRQ.QueryByItinerary.QueryPassengerItinerary.PassengerItinerary pi = new GetAncillaryOffersRQ.QueryByItinerary.QueryPassengerItinerary.PassengerItinerary();
            qpi.getPassengerItinerary().add(pi);
            queryByItinerary.getQueryPassengerItinerary().add(qpi);
            int fareComponentId = 0;
            for (int j = 0; j < segments.size(); ++j) {
                FlightSegment flightSegment = (FlightSegment)segments.get(j);
                PassengerSegment passengerSegment = new PassengerSegment();
                passengerSegment.setSegmentRef((Object)this.findSegmentById(queryByItinerary.getSegment(), segmentIdPrefix + (1 + j)));
                pi.getPassengerSegment().add(passengerSegment);
                for (com.gridnine.xtrip.common.gds.model.FareInfo fareInfoFromFlight : flightSegment.getFareInfos()) {
                    if (!fareInfoFromFlight.getPassengerType().getCode().equals(((DictionaryReference)passengersTypes.get(i)).getCode())) continue;
                    if (SabreCustomPropertiesHelper.getFareComponentDirectionality(fareInfoFromFlight) != null) {
                        fareInfo = this.addFareInfoToRequest(queryByItinerary, flightSegment, ++fareInfoIndex, ++fareComponentId, fareInfoFromFlight);
                    }
                    if (fareInfo == null) continue;
                    FareBreakAssociation fareBreakAssociation = new FareBreakAssociation();
                    fareBreakAssociation.setFareInfoRef(fareInfo);
                    passengerSegment.getFareBreakAssociation().add(fareBreakAssociation);
                }
            }
        }
        request.setVersion("3.1.0");
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"GetAncillaryOffersRQ");
        ctx.putObject((Enum)IBusGdsSabreContextKeys.SABRE_WS_SERVICE_CLASS, GetAncillaryOffersService.class);
    }

    private List<Segment> getRequestSegmentsList(List<FlightSegment> segments) throws Exception {
        ArrayList<Segment> requestSegmentsList = new ArrayList<Segment>();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = new Segment();
            segment.setId(segmentIdPrefix + (1 + i));
            com.sabre.services.merch.flight.v03.Flight flightDetail = new com.sabre.services.merch.flight.v03.Flight();
            flightDetail.setId(flightIdPrefix + (1 + i));
            flightDetail.setAirline(SabreHelper.getNativeCode((DictionaryReference)segments.get(i).getAirline()));
            flightDetail.setFlightNumber(segments.get(i).getFlightNumber());
            flightDetail.setDepartureAirport(SabreHelper.getNativeCode((DictionaryReference)segments.get(i).getLocationBegin()));
            flightDetail.setDepartureDate(this.getCalendar("yyyy-MM-dd", segments.get(i).getDateBegin()));
            flightDetail.setDepartureTime(this.getCalendar("HH:mm:ss", segments.get(i).getDateBegin()));
            flightDetail.setArrivalAirport(SabreHelper.getNativeCode((DictionaryReference)segments.get(i).getLocationEnd()));
            flightDetail.setClassOfService(segments.get(i).getBookingClass());
            segment.setFlightDetail(flightDetail);
            requestSegmentsList.add(segment);
        }
        return requestSegmentsList;
    }

    private FareInfo addFareInfoToRequest(GetAncillaryOffersRQ.QueryByItinerary queryByItinerary, FlightSegment flightSegment, int index, int fareComponentId, com.gridnine.xtrip.common.gds.model.FareInfo fareInfoFromFlight) {
        FareInfo fareInfo = new FareInfo();
        fareInfo.setId(fareIdPrefix + index);
        fareInfo.setFareComponentID(Integer.valueOf(fareComponentId));
        fareInfo.setGoverningCarrier(SabreHelper.getNativeCode((DictionaryReference)flightSegment.getAirline()));
        fareInfo.setFareBasisCode(fareInfoFromFlight.getFareBasis());
        queryByItinerary.getFareInfo().add(fareInfo);
        return fareInfo;
    }

    private Segment findSegmentById(List<Segment> segments, String id) {
        for (Segment segment : segments) {
            if (!segment.getId().equals(id)) continue;
            return segment;
        }
        return null;
    }

    protected XMLGregorianCalendar getCalendar(String format, Date date) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(format);
        String dateS = df.format(date);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(dateS);
    }
}

