/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getAncillaryFees;

import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.merch.ancillary.offer.v03.GetAncillaryOffersRS;
import com.sabre.services.merch.ancillary.v03.Offers;
import com.sabre.services.merch.common.v03.PriceElement;
import com.sabre.services.merch.products.v03.Ancillary;
import com.sabre.services.merch.products.v03.ProductDefinition;
import com.sabre.services.merch.products.v03.SpecialService;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GetAncillaryOffersRQParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        flight.setAncillaryFeesRequestNeeded(false);
        GetAncillaryOffersRS response = (GetAncillaryOffersRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List availableOffers = response.getOffers().stream().filter(offers -> offers.getAncillaryFee().getUnavailable() == false).collect(Collectors.toList());
        if (availableOffers.isEmpty()) {
            return;
        }
        Map<String, List> availableOffersByPassengerType = response.getPassengerOffers().stream().collect(Collectors.toMap(passengerOffers -> passengerOffers.getPassengerReference().getPassengerType(), passengerOffers -> availableOffers.stream().filter(offers -> passengerOffers.getOfferRefs().stream().map(o -> (Offers)o).anyMatch(offers1 -> offers1.getOfferId().equals(offers.getOfferId()))).collect(Collectors.toList())));
        Map ancillaryDefinitionById = response.getAncillaryDefinition().stream().collect(Collectors.toMap(ProductDefinition::getId, Function.identity()));
        Map ancillaryById = response.getAncillary().stream().collect(Collectors.toMap(Ancillary::getAncillaryId, Function.identity()));
        for (Map.Entry<String, List> entry : availableOffersByPassengerType.entrySet()) {
            for (Offers availableOffer : entry.getValue()) {
                AncillaryFeeDescription ancillaryFeeDescription;
                ProductDefinition pd;
                Ancillary gdsAncillary = (Ancillary)ancillaryById.get(((Ancillary)availableOffer.getAncillaryRef()).getAncillaryId());
                if (gdsAncillary == null || (pd = (ProductDefinition)ancillaryDefinitionById.get(((ProductDefinition)gdsAncillary.getAncillaryDefinitionRef()).getId())) == null || (ancillaryFeeDescription = GdsDictHelper.findAncillaryFeeDescription((AncillaryFeeType)AncillaryFeeType.BAGGAGE, (DictionaryReference)flight.getCarrier(), (String)pd.getSubCode(), (String)pd.getCommercialName(), (GdsName)flight.getGds())) == null) continue;
                AncillaryFee fee = new AncillaryFee();
                fee.setType(AncillaryFeeType.BAGGAGE);
                fee.setDescription(DictHelper.toReference((BaseDictionary)ancillaryFeeDescription));
                fee.setGdsDescription(pd.getCommercialName());
                fee.setPassengerType(DictHelper.getPassengerTypeByIATA((String)entry.getKey()));
                fee.setGdsId(fee.getUid());
                fee.setEquivalentAmount(this.getEquivalentAmountFromOffers(availableOffer));
                fee.getSegmentNumbers().addAll(this.getSegmentsNumbersFromOffers(availableOffer));
                Money baseAmountMoney = new Money();
                baseAmountMoney.setValue(availableOffer.getAncillaryFee().getBase().getAmount().getValue());
                baseAmountMoney.setCurrency(availableOffer.getAncillaryFee().getBase().getAmount().getCurrency());
                fee.setBaseAmount(baseAmountMoney);
                SabreCustomPropertiesHelper.setRficCode(fee, pd.getReasonForIssuance().getCode());
                SabreCustomPropertiesHelper.setRficSubcode(fee, pd.getSubCode());
                Optional.ofNullable(pd.getSpecialService()).map(SpecialService::getValue).ifPresent(s -> SabreCustomPropertiesHelper.setSSRCode(fee, s));
                Optional.ofNullable(pd.getSpecialServiceDetails()).ifPresent(characteristics -> SabreCustomPropertiesHelper.setSpecialServiceDetailsType(fee, characteristics.getType()));
                SabreCustomPropertiesHelper.setAncillaryGroupCode(fee, pd.getGroup());
                SabreCustomPropertiesHelper.setEMDType(fee, pd.getElectronicMiscDocType().getCode());
                flight.getAncillaryFees().add(fee);
            }
        }
    }

    private Set<Integer> getSegmentsNumbersFromOffers(Offers availableOffer) {
        HashSet<Integer> segmentNumbers = new HashSet<Integer>();
        Integer startSegmentNumber = this.getOffersSegmentNumber(availableOffer, 0);
        Integer endSegmentNumber = this.getOffersSegmentNumber(availableOffer, availableOffer.getSegment().size() - 1);
        Integer segmentNumber = startSegmentNumber - 1;
        while (segmentNumber < endSegmentNumber) {
            segmentNumbers.add(segmentNumber);
            Integer n = segmentNumber;
            Integer n2 = segmentNumber = Integer.valueOf(segmentNumber + 1);
        }
        return segmentNumbers;
    }

    private Integer getOffersSegmentNumber(Offers offers, int segmentIndex) {
        return Integer.valueOf(((Offers.Segment)offers.getSegment().get(segmentIndex)).getSegmentId().substring(((Offers.Segment)offers.getSegment().get(segmentIndex)).getSegmentId().length() - 1));
    }

    private BigDecimal getEquivalentAmountFromOffers(Offers availableOffer) {
        PriceElement totalTaxes = availableOffer.getAncillaryFee().getTotalTTLPrice();
        if (totalTaxes.getAmount() != null) {
            return totalTaxes.getAmount().getValue();
        }
        return totalTaxes.getEquivAmount().getValue();
    }
}

