/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getCouponStatus.redapp;

import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.redapp.Tax;
import com.gridnine.xtrip.common.model.redapp.sws.AirSegmentLocations;
import com.gridnine.xtrip.common.model.redapp.sws.AirTicket;
import com.gridnine.xtrip.common.model.redapp.sws.Gender;
import com.gridnine.xtrip.common.model.redapp.sws.PassengerType;
import com.gridnine.xtrip.common.model.redapp.sws.Traveller;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.ETicketCouponRS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ETicketCouponRSTicketParser
extends BaseProcessor {
    private static final Set<String> PREFIXES = Stream.of(Gender.values()).flatMap(v -> v.getPrefixes().stream()).collect(Collectors.toSet());

    public void process(MessageContext ctx) throws Exception {
        ETicketCouponRS response = (ETicketCouponRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        String ticketNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.E_TICKET_NUMBER);
        AirTicket result = new AirTicket();
        result.setNumber(ticketNumber);
        Optional<ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing> ticketingOpt = Optional.ofNullable(response).map(r -> r.getTicketingInfos()).map(i -> i.getTicketingInfo()).map(i -> i.getTicketing());
        ticketingOpt.map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing::getExchangeData).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.ExchangeData::getCouponData).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.ExchangeData.CouponData::getOriginalTicketNumber).ifPresent(arg_0 -> ((AirTicket)result).setExchangedTicketNumber(arg_0));
        ticketingOpt.map(t -> t.getCouponData()).ifPresent(couponData -> {
            Optional.ofNullable(couponData.getCustomerInfo()).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.CustomerInfo::getCustomer).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.CustomerInfo.Customer::getPersonName).map(ETicketCouponRSTicketParser::convertSWS2Traveler).ifPresent(arg_0 -> ((AirTicket)result).setTraveller(arg_0));
            Optional.ofNullable(couponData.getCoupons()).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.Coupons::getCouponList).orElseGet(Collections::emptyList).stream().map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.Coupons.Coupon::getFlightSegment).filter(Objects::nonNull).map(i -> ETicketCouponRSTicketParser.convertSWS2Locations(i)).collect(Collectors.toCollection(() -> ((AirTicket)result).getLocations()));
            Optional.ofNullable(couponData.getAirItineraryPricingInfo()).ifPresent(pricingInfo -> {
                Optional.ofNullable(pricingInfo.getEndorsements()).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.AirItineraryPricingInfo.Endorsements::getTextList).map(l -> String.join((CharSequence)"/", l)).ifPresent(arg_0 -> ((AirTicket)result).setEndorsement(arg_0));
                Optional.ofNullable(pricingInfo.getItinTotalFare()).ifPresent(totalFare -> {
                    result.setEquivalentFare(ETicketCouponRSTicketParser.convertSWS2EquivFare(totalFare.getEquivFare()));
                    result.setBaseFare(ETicketCouponRSTicketParser.convertSWS2BaseFare(totalFare.getBaseFare()));
                    if (totalFare.getTaxes() != null) {
                        totalFare.getTaxes().getTaxList().stream().map(ETicketCouponRSTicketParser::convertSWS2Tax).filter(Objects::nonNull).collect(Collectors.toCollection(() -> ((AirTicket)result).getTaxes()));
                    }
                });
            });
        });
        ctx.putObject((Enum)IBusGdsContextKeys.AIR_TICKET, (Object)result);
    }

    private static AirSegmentLocations convertSWS2Locations(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.Coupons.Coupon.FlightSegment source) {
        AirSegmentLocations result = new AirSegmentLocations();
        Optional.ofNullable(source.getDestinationLocation()).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.Coupons.Coupon.FlightSegment.DestinationLocation::getLocationCode).ifPresent(arg_0 -> ((AirSegmentLocations)result).setArrivalLocation(arg_0));
        Optional.ofNullable(source.getOriginLocation()).map(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.Coupons.Coupon.FlightSegment.OriginLocation::getLocationCode).ifPresent(arg_0 -> ((AirSegmentLocations)result).setDepartureLocation(arg_0));
        return result;
    }

    private static Traveller convertSWS2Traveler(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.CustomerInfo.Customer.PersonName p) {
        Traveller result = new Traveller();
        result.setLastName(p.getSurname());
        String givenName = p.getGivenName();
        String middleName = null;
        if (givenName != null) {
            if (givenName.endsWith(" CHD") || givenName.endsWith(" INF")) {
                givenName = givenName.substring(0, givenName.length() - 4);
            }
            middleName = ETicketCouponRSTicketParser.convertSWSGivenNameToMiddleName(givenName);
            givenName = ETicketCouponRSTicketParser.convertSWSGivenNameToFirstName(givenName);
        }
        result.setMiddleName(middleName);
        result.setFirstName(givenName);
        result.setPassengerType(PassengerType.ofCode((String)p.getPassengerType()));
        return result;
    }

    private static String convertSWSGivenNameToFirstName(String givenName) {
        String firstName = givenName.split(" ")[0];
        if (!PREFIXES.contains(firstName)) {
            return firstName;
        }
        return null;
    }

    private static String convertSWSGivenNameToMiddleName(String givenName) {
        String middleName = Stream.of(givenName.split(" ")).skip(1L).filter(s -> !PREFIXES.contains(s)).collect(Collectors.joining(" "));
        if (!middleName.isEmpty()) {
            return middleName;
        }
        return null;
    }

    private static Tax convertSWS2Tax(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax t) {
        if (t == null || !ValidationUtil.isNumber((String)t.getAmount())) {
            return null;
        }
        Tax result = new Tax();
        result.setAmount(ETicketCouponRSTicketParser.parseAmount(t.getAmount()));
        result.setCode(t.getTaxCode());
        result.setPaid("PD".equalsIgnoreCase(t.getPaid()));
        return result;
    }

    private static Money convertSWS2BaseFare(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.AirItineraryPricingInfo.ItinTotalFare.BaseFare f) {
        if (f == null) {
            return null;
        }
        Money result = new Money();
        result.setValue(ETicketCouponRSTicketParser.parseAmount(f.getAmount()));
        result.setCurrency(f.getCurrencyCode());
        return result;
    }

    private static Money convertSWS2EquivFare(ETicketCouponRS.TicketingInfos.TicketingInfo.Ticketing.CouponData.AirItineraryPricingInfo.ItinTotalFare.EquivFare f) {
        if (f == null) {
            return null;
        }
        Money result = new Money();
        result.setValue(ETicketCouponRSTicketParser.parseAmount(f.getAmount()));
        result.setCurrency(f.getCurrencyCode());
        return result;
    }

    private static BigDecimal parseAmount(String f) {
        if (TextUtil.isBlank((String)f)) {
            return null;
        }
        try {
            return new BigDecimal(f);
        }
        catch (Exception e) {
            return null;
        }
    }
}

