/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getFareRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreRemarksSearchContext;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class GetFareRulesAirPriceRQParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String nameNumber;
        String fareRemarksSearchContextStr = (String)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_REMARKS_SEARCH_CONTEXT);
        SabreRemarksSearchContext context = new SabreRemarksSearchContext();
        XUtil.fromString((String)fareRemarksSearchContextStr, (XSerializable)context);
        DictionaryReference pt = SabreHelper.resolveNativeCode(PassengerType.class, (String)context.getPType());
        AirPriceRQParameters parameters = new AirPriceRQParameters();
        parameters.getPassengerTypes().add(new MiscUtil.Pair((Object)context.getPType(), null));
        parameters.setRetain(false);
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityReference specialTariffRef = null;
        if (reservation != null) {
            specialTariffRef = reservation.getSpecialTariff();
            if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
                parameters.getAccountCodes().add(reservation.getAccountCode());
            }
            parameters.setCorporateId(reservation.getCorporateId());
            Product product = GetFareRulesAirPriceRQParametersProcessor.findProductByPType(reservation, context.getPType());
            parameters.setCarrier(product.getCarrier());
            parameters.setGdsCurrencyCode(product.getGdsCurrency());
            parameters.setTourCode(product.getTourCode());
            parameters.setTripartiteContractDetails(product.getTripartiteContractDetails());
            for (Segment segment : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
                parameters.getSegmentNumbers().add(segment.getGdsId());
            }
            parameters.getBrandIds().addAll(AirPriceHelper.getBrandIds(product));
            if (product.getReservation().isSabreSmartPricePricing()) {
                Product adultProduct = GetFareRulesAirPriceRQParametersProcessor.findProductByPType(reservation, SabreHelper.getNativeCode((DictionaryReference)DictHelper.getAdultPassengerType()));
                parameters.getSmartPriceFareBasises().addAll(AirPriceHelper.getSmartPriceFareBasises(adultProduct));
            }
            parameters.setPublicFare(AirPriceHelper.getPublicFare(product));
            parameters.setRefundableAny(AirPriceHelper.getRefundableAny(product));
            if (SabreHelper.isTchBlankOwner((EntityReference)product.getBlankOwnerRef())) {
                parameters.setValidationMethod("TCH");
            }
        } else {
            Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
            specialTariffRef = flight.getSpecialTariff();
            parameters.setGdsAccount(flight.getGdsAccount());
            if (!StringUtils.isBlank((String)flight.getAccountCode())) {
                parameters.getAccountCodes().add(flight.getAccountCode());
            }
            parameters.setCorporateId(flight.getCorporateId());
            parameters.setCarrier(flight.getCarrier());
            parameters.setTourCode(flight.getTourCode());
            parameters.setTripartiteContractDetails(flight.getTripartiteContractDetails());
            for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
                parameters.getSegmentNumbers().add(fs.getGdsId());
            }
            parameters.getBrandIds().addAll(AirPriceHelper.getBrandIds(flight, (DictionaryReference<PassengerType>)pt));
            if (flight.isSabreSmartPricePricing()) {
                parameters.getSmartPriceFareBasises().addAll(AirPriceHelper.getSmartPriceFareBasises(flight, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType()));
            }
            parameters.setPublicFare(AirPriceHelper.getPublicFare(flight, (DictionaryReference<PassengerType>)pt));
            parameters.setRefundableAny(AirPriceHelper.getRefundableAny(flight, (DictionaryReference<PassengerType>)pt));
            if (SabreHelper.isTchBlankOwner((EntityReference)flight.getBlankOwner())) {
                parameters.setValidationMethod("TCH");
            }
        }
        if (specialTariffRef != null) {
            SpecialTariff specialTariff = (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity();
            parameters.setExemptAllTaxes(specialTariff.isExcludeTaxes());
            parameters.setResidentCountry(specialTariff.getResidentCountry());
        }
        if ((nameNumber = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER)) != null) {
            parameters.getNameNumbers().add(nameNumber);
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS, (Object)parameters);
    }

    private static Product findProductByPType(Reservation reservation, String pType) {
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            if (!pType.equals(SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType()))) continue;
            return prod;
        }
        return null;
    }
}

