/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItem;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.bookability.GdsBookability;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GetReservationBookabilityProcessor
extends BaseProcessor {
    private String requiredStatus;

    public void configure(Map<String, String> parameters) {
        this.requiredStatus = parameters.get("required-status");
    }

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        ArrayList<GdsBookabilityItem> bookabilityItems = new ArrayList<GdsBookabilityItem>();
        byte[] flightData = GdsBookability.getFlightData((Flight)params.getFlight());
        List<AirType> airs = GetReservationHelper.getAirs(response);
        for (int i = 0; i < airs.size(); ++i) {
            AirType air = airs.get(i);
            if (this.requiredStatus.equals(air.getActionCode())) continue;
            GdsBookabilityItem bi = this.buildBookabilityItem(air);
            bi.setFlightData(flightData);
            bookabilityItems.add(bi);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_BOOKABILITY_ITEMS, bookabilityItems);
    }

    private GdsBookabilityItem buildBookabilityItem(AirType air) {
        GdsBookabilityItem bi = new GdsBookabilityItem();
        bi.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)air.getMarketingAirlineCode()));
        bi.setArrivalLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getArrivalAirport()));
        bi.setDepartureLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getDepartureAirport()));
        bi.setDate(new Date());
        bi.setBookingClass(air.getResBookDesigCode());
        bi.setDateBegin(GetReservationHelper.getActualDepartureTime(air));
        bi.setDateEnd(GetReservationHelper.getActualArrivalTime(air));
        bi.setDescription(String.format("segment status: '%s'", air.getResBookDesigCode()));
        bi.setFlightNumber(GetReservationHelper.getFlightNumber(air));
        if (air.getNumberInParty() != null) {
            bi.setSeatsCount(Integer.valueOf(air.getNumberInParty().intValue()));
        }
        bi.setGds(GdsName.SABRE);
        return bi;
    }
}

