/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.ReservationChangedInGdsException;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import com.sabre.webservices.pnrbuilder.v119.PassengerReservationPNRB;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.FastDateFormat;

public class GetReservationCheckModificationsProcessor
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"yyyy-MM-dd");

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation;
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        if (!this.check(response, reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION))) {
            throw new ReservationChangedInGdsException();
        }
    }

    private boolean check(GetReservationRSType response, Reservation reservation) {
        Set momNameNumbers;
        if (response.getReservation().getReservationChoiceGroup().getPassengerReservation() == null || response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers() == null || response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList() == null) {
            return false;
        }
        PassengerReservationPNRB incReservation = response.getReservation().getReservationChoiceGroup().getPassengerReservation();
        Set gdsNameNumbers = incReservation.getPassengers().getPassengerList().stream().map(PassengerPNRB::getNameId).map(SabreHelper::fixNameNumber).collect(Collectors.toSet());
        if (!gdsNameNumbers.equals(momNameNumbers = AirProductHelper.getAirProductsList((Reservation)reservation).stream().map(Product::getGdsId).collect(Collectors.toSet()))) {
            return false;
        }
        if (incReservation.getSegments() == null) {
            return false;
        }
        Set gdsSegments = GetReservationHelper.getAirs(response).stream().map(air -> {
            try {
                return String.join((CharSequence)"|", air.getMarketingAirlineCode(), GetReservationHelper.getFlightNumber(air), DF.format(MiscUtil.clearTime((Date)GetReservationHelper.getActualDepartureTime(air))));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toSet());
        Set momSegments = AirProductHelper.getAirProductsList((Reservation)reservation).stream().map(Product::getSegmentTariffs).flatMap(sts -> AirProductHelper.getSegments((Collection)sts).stream()).map(seg -> String.join((CharSequence)"|", SabreHelper.getNativeCode((DictionaryReference)seg.getAirline()), seg.getFlightNo(), DF.format(MiscUtil.clearTime((Date)seg.getStartDate())))).collect(Collectors.toSet());
        Set gdsMcoIds = GetReservationHelper.getAncillaryServices(response).stream().filter(as -> (!"HK".equals(as.getAncillaryServicesDataGroupPNRB().getActionCode()) || !"KK".equals(as.getAncillaryServicesDataGroupPNRB().getActionCode())) && !as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO)).map(AncillaryServicesPNRB::getId).collect(Collectors.toSet());
        Set momMcoIds = GDSHelper.getMcoProducts((Reservation)reservation).stream().filter(mco -> mco.getStatus() == ProductStatus.BOOKING || mco.getStatus() == ProductStatus.SELL).map(Product::getGdsId).collect(Collectors.toSet());
        return gdsSegments.equals(momSegments) && gdsMcoIds.equals(momMcoIds);
    }
}

