/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.xtrip.common.gds.exceptions.NoSegmentsInBookingException;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetReservationCheckResponseProcessor
extends BaseProcessor {
    private static final Map<String, L10nMessage> ERROR_STATUS_TRANSLATIONS = new HashMap<String, L10nMessage>();

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        String command = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.WORKFLOW_COMMAND);
        List<AirType> airs = GetReservationHelper.getAirs(response);
        if (!airs.isEmpty()) {
            for (AirType air : airs) {
                L10nMessage errorMessage = ERROR_STATUS_TRANSLATIONS.get(air.getActionCode());
                if (errorMessage == null || "CANCEL".equalsIgnoreCase(command)) continue;
                throw new Xeption(errorMessage, null, null, null);
            }
        } else {
            throw new NoSegmentsInBookingException();
        }
    }

    static {
        ERROR_STATUS_TRANSLATIONS.put("HX", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_NOT_POSSIBLE_AS_ONE_OR_MORE_SEGMENTS_CANCELED_BY_AIRLINE", (Object[])new Object[0]));
        ERROR_STATUS_TRANSLATIONS.put("UC", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_IMPOSSIBLE_BECAUSE_THE_SEATS_ON_ONE_OF_THE_FLIGHTS_CANCELED_BY_THE_AIRLINE", (Object[])new Object[0]));
        ERROR_STATUS_TRANSLATIONS.put("NO", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_IMPOSSIBLE_BECAUSE_THE_SEATS_ON_ONE_OF_THE_FLIGHTS_CANCELED_BY_THE_AIRLINE_NO_STATUS", (Object[])new Object[0]));
    }
}

