/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.sabre.exceptions.TkStatusException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GetReservationCheckSegmentStatusProcessor
extends BaseProcessor {
    private String requiredStatus;
    private boolean handleTk;
    private boolean collectSegments;

    public void configure(Map<String, String> parameters) {
        this.requiredStatus = parameters.get("required-status");
        this.handleTk = Boolean.parseBoolean(parameters.get("handle-tk"));
        this.collectSegments = Boolean.parseBoolean(parameters.get("collect-segments"));
    }

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List<AirType> airs = GetReservationHelper.getAirs(response);
        if (airs.isEmpty()) {
            throw Xeption.forEndUser((String)"\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u044b", (Object[])new Object[0]);
        }
        SeatsNotConfirmedException ex = this.collectSegments ? new SeatsNotConfirmedException(airs.stream().collect(Collectors.toMap(GetReservationHelper::parseFlightSegment, AirType::getActionCode))) : new SeatsNotConfirmedException();
        Set actionCodes = airs.stream().map(AirType::getActionCode).collect(Collectors.toSet());
        boolean hadTk = false;
        if (this.handleTk) {
            hadTk = actionCodes.remove("TK");
        }
        if (actionCodes.size() == 1) {
            if (!this.requiredStatus.equals(actionCodes.iterator().next())) {
                throw ex;
            }
            if (hadTk) {
                throw new TkStatusException();
            }
        } else {
            throw ex;
        }
    }
}

