/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.FareOverlay;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.OBFeesInfo;
import com.gridnine.xtrip.common.gds.model.SegmentStatus;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicator;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SegmentHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.AmountPattern;
import com.sabre.ns.ticketing.pqs.CodeEndorsementType;
import com.sabre.ns.ticketing.pqs.CodePQType;
import com.sabre.ns.ticketing.pqs.FareTax;
import com.sabre.ns.ticketing.pqs.FareTaxInfo;
import com.sabre.ns.ticketing.pqs.MessageEndorsementType;
import com.sabre.ns.ticketing.pqs.MessageTextType;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.ns.ticketing.pqs.PriceQuoteItemOBFeeDetails;
import com.sabre.ns.ticketing.pqs.SegmentBaggageInfo;
import com.sabre.webservices.pnrbuilder.v119.AccountingLinePNRB;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRQ;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import com.sabre.webservices.pnrbuilder.v119.PassengerReservationPNRB;
import com.sabre.webservices.pnrbuilder.v119.PassengersPNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkLinePNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkPNRB;
import com.sabre.webservices.pnrbuilder.v119.ReservationChoiceGroup;
import com.sabre.webservices.pnrbuilder.v119.ReservationPNRB;
import com.sabre.webservices.pnrbuilder.v119.ReturnOptionsPNRB;
import com.sabre.webservices.pnrbuilder.v119.SegmentOrTravelPortionType;
import com.sabre.webservices.pnrbuilder.v119.SegmentTypePNRB;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetReservationHelper {
    private static final DateTimeFormatter TF_HH_MM = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter DTF_HIDDEN_STOP = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
    public static final Pattern PATTERN_SUPPLIER_REF = Pattern.compile("[A-Z]{2}[A-Z0-9]{2}\\*([A-Z0-9]+)");
    private static final Set<String> IGNORED_PQ_STATUSES = new HashSet<String>();
    private static final String LUGGAGE_UNIT_NIL = "NIL";
    private static final Pattern P_PASSENGER_TYPE_NOT_APPLICABLE;
    private static final Pattern P_DISCLOSURE_CARRIER_BANNER_AIRLINE;

    public static List<SegmentTypePNRB.Segment> getSegments(GetReservationRSType response) {
        return Optional.ofNullable(response.getReservation()).map(ReservationPNRB::getReservationChoiceGroup).map(ReservationChoiceGroup::getPassengerReservation).map(PassengerReservationPNRB::getSegments).map(SegmentTypePNRB::getSegmentList).orElse(Collections.emptyList());
    }

    public static List<AirType> getAirs(GetReservationRSType response) {
        return GetReservationHelper.getSegments(response).stream().map(SegmentTypePNRB.Segment::getAir).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static FlightSegment parseFlightSegment(AirType air) {
        Set items;
        FlightSegment fs = new FlightSegment();
        DictionaryReference marketingAirline = SabreHelper.resolveNativeCode(Airline.class, (String)air.getMarketingAirlineCode());
        fs.setAirline(marketingAirline);
        fs.setBlockCharter(false);
        fs.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)air.getEquipmentType()));
        fs.setBookingClass(air.getResBookDesigCode());
        fs.setDateBegin(GetReservationHelper.getActualDepartureTime(air));
        fs.setDateEnd(GetReservationHelper.getActualArrivalTime(air));
        fs.setFlightNumber(GetReservationHelper.getFlightNumber(air));
        fs.setGds(GdsName.SABRE);
        DictionaryReference locationBegin = SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getDepartureAirport());
        fs.setLocationBegin(locationBegin);
        fs.setTerminalBegin(air.getDepartureTerminalCode());
        DictionaryReference locationEnd = SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getArrivalAirport());
        fs.setLocationEnd(locationEnd);
        fs.setTerminalEnd(air.getArrivalTerminalCode());
        DictionaryReference<Airline> operatingAirline = GetReservationHelper.getOperatingAirline(air);
        if (operatingAirline != null) {
            fs.setOperatingAirline(operatingAirline);
        } else {
            fs.setOperatingAirline(marketingAirline);
        }
        fs.setStatus("SS".equals(air.getActionCode()) ? SegmentStatus.CONFIRMED : SegmentStatus.UNCONFIRMED);
        if (air.getHiddenStopList() != null) {
            fs.setStops(air.getHiddenStopList().size());
            fs.addTechStopInfos(GetReservationHelper.readTechStops(air));
        }
        if (air.getElapsedTime() != null) {
            fs.setTravelDuration(GetReservationHelper.getTravelDuration(air.getElapsedTime()));
        }
        if (air.getMealList() != null && air.getMealList().size() > 0 && !(items = DictHelper.getDictionaryItemsByCode(MealServiceIndicator.class, (String)((AirType.Meal)air.getMealList().get(0)).getCode())).isEmpty()) {
            fs.setMealServiceIndicator((DictionaryReference)((MealServiceIndicator)items.iterator().next()).toReference());
        }
        fs.setGdsId(air.getSequence().toString());
        return fs;
    }

    public static Date getActualDepartureTime(AirType air) {
        return Date.from(GetReservationHelper.getActualDepartureDateTime(air).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime getActualDepartureDateTime(AirType air) {
        LocalDateTime result = LocalDateTime.parse(air.getDepartureDateTime());
        if (air.getUpdatedDepartureDate() != null) {
            result = result.toLocalTime().atDate(LocalDate.parse(air.getUpdatedDepartureDate()));
        }
        if (air.getUpdatedDepartureTime() != null) {
            result = result.toLocalDate().atTime(LocalTime.parse(air.getUpdatedDepartureTime(), TF_HH_MM));
        }
        return result;
    }

    public static LocalDateTime getActualDepartureDateTime(com.sabre.services.res.or.v114.AirType air) {
        LocalDateTime result = MiscUtil.toLocalDateTime((Date)air.getDepartureDateTime());
        if (air.getUpdatedDepartureDate() != null) {
            result = result.toLocalTime().atDate(LocalDate.parse(air.getUpdatedDepartureDate()));
        }
        if (air.getUpdatedDepartureTime() != null) {
            result = result.toLocalDate().atTime(LocalTime.parse(air.getUpdatedDepartureTime(), TF_HH_MM));
        }
        return result;
    }

    public static Date getActualArrivalTime(AirType air) {
        return Date.from(GetReservationHelper.getActualArrivalDateTime(air).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime getActualArrivalDateTime(AirType air) {
        LocalDateTime result = LocalDateTime.parse(air.getArrivalDateTime());
        if (air.getUpdatedArrivalTime() != null) {
            result = result.toLocalDate().atTime(LocalTime.parse(air.getUpdatedArrivalTime(), TF_HH_MM));
        }
        return result;
    }

    public static LocalDateTime getActualArrivalDateTime(com.sabre.services.res.or.v114.AirType air) {
        LocalDateTime result = MiscUtil.toLocalDateTime((Date)air.getArrivalDateTime());
        if (air.getUpdatedArrivalTime() != null) {
            result = result.toLocalDate().atTime(LocalTime.parse(air.getUpdatedArrivalTime(), TF_HH_MM));
        }
        return result;
    }

    public static String getFlightNumber(AirType air) {
        return GetReservationHelper.getFlightNumber(air.getFlightNumber());
    }

    public static String getFlightNumber(com.sabre.services.res.or.v114.AirType air) {
        return GetReservationHelper.getFlightNumber((String)MiscUtil.guarded((Object)air.getFlightNumber(), (Object)air.getMarketingFlightNumber()));
    }

    public static String getFlightNumber(String flightNumber) {
        int idx;
        int len = flightNumber.length();
        for (idx = 0; idx < len && flightNumber.charAt(idx) == '0'; ++idx) {
        }
        return idx > 0 ? flightNumber.substring(idx) : flightNumber;
    }

    public static List<TechStopInfo> readTechStops(AirType air) {
        if (air.getHiddenStopList() == null || air.getHiddenStopList().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TechStopInfo> techStops = new ArrayList<TechStopInfo>();
        for (AirType.HiddenStop stop : air.getHiddenStopList()) {
            TechStopInfo techStop = new TechStopInfo();
            techStop.setArrivalDateTime(LocalDateTime.parse(stop.getArrivalDateTime(), DTF_HIDDEN_STOP));
            techStop.setDepartureDateTime(LocalDateTime.parse(stop.getArrivalDateTime(), DTF_HIDDEN_STOP));
            techStop.setLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)stop.getAirport()));
            techStop.setDuration(Math.toIntExact(ChronoUnit.MINUTES.between(techStop.getDepartureDateTime(), techStop.getArrivalDateTime())));
            techStops.add(techStop);
        }
        return techStops;
    }

    public static int getTravelDuration(String elapsedTime) {
        return 60 * Integer.parseInt(elapsedTime.substring(0, 2)) + Integer.parseInt(elapsedTime.substring(3));
    }

    public static String getRemarkText(RemarkPNRB remark) {
        return ((RemarkLinePNRB)remark.getRemarkLines().getRemarkLineList().get(0)).getText();
    }

    public static List<PriceQuoteDetails> getValidPriceQuotes(GetReservationRSType response) {
        ArrayList<PriceQuoteDetails> result = new ArrayList<PriceQuoteDetails>();
        if (response.getPriceQuote() != null && response.getPriceQuote().getPriceQuoteInfo() != null && response.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG() != null && response.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG().getDetailList() != null) {
            result.addAll(response.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG().getDetailList());
            HashMap pqs = new HashMap();
            response.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG().getDetailList().stream().filter(dl -> dl.getType().equals((Object)CodePQType.PQ) && !IGNORED_PQ_STATUSES.contains(dl.getStatus())).forEach(dl -> pqs.put(GetReservationHelper.deteminePassengerTypeCode(dl), dl));
            result.retainAll(pqs.values());
        }
        return result;
    }

    public static String deteminePassengerTypeCode(PriceQuoteDetails details) {
        if (details.getMessageInfo() != null && details.getMessageInfo().getMessageList() != null) {
            for (MessageTextType message : details.getMessageInfo().getMessageList()) {
                Matcher matcher;
                if (message.getString() == null || !(matcher = P_PASSENGER_TYPE_NOT_APPLICABLE.matcher(message.getString())).matches()) continue;
                return matcher.group("originalPtc");
            }
        }
        return details.getPassengerType();
    }

    public static String getNameNumberFromAccountingLine(AccountingLinePNRB line) {
        char c;
        int idx;
        String s = line.getPassengerName();
        for (idx = 0; idx < s.length() && ((c = s.charAt(idx)) == '.' || c >= '0' && c <= '9'); ++idx) {
        }
        return s.substring(0, idx);
    }

    public static GetReservationRQ buildReservationRequestWithRecordLocator(String recordLocator) {
        GetReservationRQ request = new GetReservationRQ();
        request.setVersion("1.19.11");
        request.setLocator(recordLocator);
        ReturnOptionsPNRB ro = new ReturnOptionsPNRB();
        ro.setViewName("Full");
        ro.setResponseFormat("STL");
        ro.setPriceQuoteServiceVersion("4.1.0");
        ro.setSubjectAreas(new ReturnOptionsPNRB.SubjectAreas());
        ro.getSubjectAreas().setSubjectAreaList(new ArrayList());
        ro.getSubjectAreas().getSubjectAreaList().add("PRICE_QUOTE");
        ro.getSubjectAreas().getSubjectAreaList().add("ADD_ACCOUNTING_LINE_NAME_NUMBER");
        ro.getSubjectAreas().getSubjectAreaList().add("ACCOUNTING_LINE");
        request.setReturnOptions(ro);
        return request;
    }

    public static DictionaryReference<Airline> getOperatingAirline(AirType air) {
        if (air.getDisclosureCarrier() != null && air.getDisclosureCarrier().getCode() != null) {
            Matcher m;
            if (air.getDisclosureCarrier().getBanner() != null && (m = P_DISCLOSURE_CARRIER_BANNER_AIRLINE.matcher(air.getDisclosureCarrier().getBanner())).matches()) {
                return SabreHelper.resolveNativeCode(Airline.class, (String)m.group("code"));
            }
            return SabreHelper.resolveNativeCode(Airline.class, (String)air.getDisclosureCarrier().getCode());
        }
        if (air.getOperatingAirlineCode() != null) {
            String code = air.getOperatingAirlineCode();
            if ("**".equals(code)) {
                String banner = air.getOperatingAirlineShortName();
                String spellVariant = SabreServerHelper.getSpellVariantFrom(banner);
                return SabreServerHelper.findOrCreateAirlineBySpellVariant(spellVariant);
            }
            return SabreHelper.resolveNativeCode(Airline.class, (String)air.getOperatingAirlineCode());
        }
        return null;
    }

    public static Map<String, String> getBrandIds(PriceQuoteDetails pq) {
        HashMap<String, String> result = new HashMap<String, String>();
        pq.getSegmentInfoList().stream().filter(si -> si.getBrandedFare() != null && !StringUtils.isBlank((String)si.getBrandedFare().getCode())).forEach(si -> result.put(si.getSegNumber(), si.getBrandedFare().getCode()));
        return result;
    }

    public static Product parseMcoProduct(AncillaryServicesPNRB as, Reservation reservation, PassengerPNRB passenger) throws Exception {
        String nameNumber = SabreHelper.fixNameNumber((String)passenger.getNameId());
        Product ticketProduct = reservation.getProducts().stream().map(baseProduct -> (Product)baseProduct).filter(baseProduct -> GDSHelper.getTravellerGdsIdWithFallback((Product)baseProduct).equals(nameNumber)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ticketProduct with nameNumber = {0}", (Object[])new Object[]{nameNumber}));
        Product product = new Product();
        product.setReservation(reservation);
        product.setMcoCancellationAllowed(true);
        product.setProductCategory(ProductCategory.MCO);
        product.setGdsId(as.getId());
        product.setPassengerType(SabreHelper.resolveNativeCode(PassengerType.class, (String)passenger.getPassengerType()));
        product.setTravellerGdsId(nameNumber);
        product.getRelatedProducts().add(ticketProduct);
        product.setTraveller(ticketProduct.getTraveller());
        product.setTariffType(ticketProduct.getTariffType());
        String currency = as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getCurrency();
        product.setGdsCurrency(StringUtils.isBlank((String)currency) ? ticketProduct.getGdsCurrency() : currency);
        product.setRfic(as.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getRficCode());
        product.setRfisc(as.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getRficSubcode());
        AirProductHelper.setBaseFare((Product)product, (Money)MoneyHelper.buildMoney((BigDecimal)as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalOriginalBasePrice().getPrice(), (String)as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalOriginalBasePrice().getCurrency()));
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice());
        product.setMcoReservationRequestStatus(SabreServerHelper.actionCode2MCOReservationRequestStatus(as.getAncillaryServicesDataGroupPNRB().getActionCode()));
        product.setMcoCategory(GetReservationHelper.parseMcoCategory(as));
        product.setCarrier(ticketProduct.getCarrier());
        SegmentTariff st = new SegmentTariff();
        List<Segment> originalTicketSegments = GetReservationHelper.getOriginalSegmentListFromTicketForMcoProduct(ticketProduct, as);
        for (Segment originalTicketSegment : originalTicketSegments) {
            if (product.getMcoCategory() == MCOCategory.SEAT_RESERVATION && product.getMcoReservationRequestStatus() == MCOReservationRequestStatus.CONFIRMED) {
                originalTicketSegment.setSeatNo(as.getAncillaryServicesDataGroupPNRB().getPdcSeat());
            }
            Segment cloneTicketSegment = (Segment)XCloneHelper.clone((XCloneable)SegmentHelper.findSegment((List)AirProductHelper.getProductSegmentsList((Product)ticketProduct), (Segment)originalTicketSegment), (boolean)true);
            st.getSegments().add(cloneTicketSegment);
        }
        product.getSegmentTariffs().add(st);
        return product;
    }

    public static MCOCategory parseMcoCategory(AncillaryServicesPNRB as) {
        AncillaryFeeType feeType = GdsDictHelper.parseAncillaryFeeType((String)as.getAncillaryServicesDataGroupPNRB().getGroupCode());
        switch (feeType) {
            case BAGGAGE: {
                return MCOCategory.EXCESS_LUGGAGE;
            }
            case PREFERRED_SEATING: {
                return MCOCategory.SEAT_RESERVATION;
            }
        }
        throw Xeption.forDeveloper((String)"unsupported ancillary fee type {0}", (Object[])new Object[]{feeType});
    }

    public static List<Segment> getOriginalSegmentListFromTicketForMcoProduct(Product ticketProduct, AncillaryServicesPNRB as) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        if (as.getAncillaryServicesDataGroupPNRB().getSegment() != null) {
            SegmentOrTravelPortionType gdsSeg = as.getAncillaryServicesDataGroupPNRB().getSegment();
            Segment s = new Segment();
            s.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)gdsSeg.getAirlineCode()));
            s.setFlightNo(GetReservationHelper.getFlightNumber(gdsSeg.getFlightNumber()));
            s.setClassOfSvcCode(gdsSeg.getClassOfService());
            s.setDepartureLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)gdsSeg.getBoardPoint()));
            s.setArriveLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)gdsSeg.getOffPoint()));
            Segment ticketSegment = SegmentHelper.findSegment((List)AirProductHelper.getProductSegmentsList((Product)ticketProduct), (Segment)s);
            if (ticketSegment != null) {
                result.add(ticketSegment);
            }
        } else if (as.getAncillaryServicesDataGroupPNRB().getTravelPortions() != null) {
            for (SegmentOrTravelPortionType gdsSeg : as.getAncillaryServicesDataGroupPNRB().getTravelPortions().getTravelPortionList()) {
                Segment s = new Segment();
                s.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)gdsSeg.getAirlineCode()));
                s.setFlightNo(GetReservationHelper.getFlightNumber(gdsSeg.getFlightNumber()));
                s.setClassOfSvcCode(gdsSeg.getClassOfService());
                s.setDepartureLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)gdsSeg.getBoardPoint()));
                s.setArriveLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)gdsSeg.getOffPoint()));
                Segment ticketSegment = SegmentHelper.findSegment((List)AirProductHelper.getProductSegmentsList((Product)ticketProduct), (Segment)s);
                if (ticketSegment == null) continue;
                result.add(ticketSegment);
            }
        }
        return result;
    }

    public static Date getConvertedLastTicketingDate(MessageContext ctx) throws Exception {
        Date lastTicketingDate = (Date)ctx.getObject((Enum)IBusGdsSabreContextKeys.LAST_TICKETING_DATE);
        if (lastTicketingDate == null) {
            return null;
        }
        Pcc ticketingPcc = GetReservationHelper.getTicketingPcc(ctx);
        if (ticketingPcc == null) {
            return null;
        }
        Date timelimit = GDSHelper.convertTimelimitFromPcc((Date)lastTicketingDate, (Pcc)ticketingPcc);
        Date mcoTimelimit = (Date)ctx.getObject((Enum)IBusGdsSabreContextKeys.MCO_TIME_LIMIT);
        if (mcoTimelimit != null) {
            EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            if ((mcoTimelimit = GDSHelper.convertTimelimitFromPcc((Date)mcoTimelimit, (Pcc)SabreHelper.getPcc((SabreGdsAccount)((SabreGdsAccount)gdsAccountCtr.getEntity()), (SalesContext)salesContext))).before(timelimit)) {
                timelimit = mcoTimelimit;
            }
        }
        return timelimit;
    }

    private static Pcc getTicketingPcc(MessageContext ctx) {
        Product anyProduct;
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (reservation != null && !reservation.getProducts().isEmpty() && (anyProduct = (Product)AirProductHelper.getProducts((Reservation)reservation).get(0)).getPcc() != null) {
            return PccHelper.findPccGds((String)anyProduct.getPcc(), (GdsName)GdsName.SABRE, (EntityReference)anyProduct.getSalesPoint());
        }
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        return PccHelper.getTicketingPcc((GDSParameters)gdsParameters, (EntityReference)salesContext.getSalesPoint(), (GdsName)flight.getGds());
    }

    public static BigDecimal parseEquivalentFare(PriceQuoteDetails pq) {
        if (pq.getFareInfo().getEquivalentFare() != null) {
            return new BigDecimal(pq.getFareInfo().getEquivalentFare().getString());
        }
        return new BigDecimal(pq.getFareInfo().getBaseFare().getString());
    }

    public static AmountPattern getEquivalentFareFromPq(PriceQuoteDetails pq) {
        if (pq.getFareInfo().getEquivalentFare() != null) {
            return pq.getFareInfo().getEquivalentFare();
        }
        return pq.getFareInfo().getBaseFare();
    }

    public static boolean parseObFeesInfo(PriceQuoteDetails pq, OBFeesInfo info) {
        if (pq.getFeeInfo() != null && pq.getFeeInfo().getOBFeeList() != null) {
            BigDecimal minFee = null;
            BigDecimal maxFee = null;
            for (PriceQuoteItemOBFeeDetails obFeeDetails : pq.getFeeInfo().getOBFeeList()) {
                if (!"OB".equals(obFeeDetails.getType()) || obFeeDetails.getAmount() == null) continue;
                BigDecimal fee = obFeeDetails.getAmount().getDecimal();
                if (minFee == null || minFee.compareTo(fee) > 0) {
                    minFee = fee;
                }
                if (maxFee != null && maxFee.compareTo(fee) >= 0) continue;
                maxFee = fee;
            }
            if (minFee != null) {
                info.setMinFee(minFee);
                info.setMaxFee(maxFee);
                return true;
            }
        }
        return false;
    }

    public static Collection<TaxAbstraction> parseTaxes(FareTaxInfo taxes) {
        HashSet<TaxAbstraction> result = new HashSet<TaxAbstraction>();
        if (taxes != null && taxes.getTaxList() != null) {
            for (FareTax taxInput : taxes.getTaxList()) {
                if ((StringUtils.isEmpty((String)taxInput.getCode()) || "TE".equals(taxInput.getCode())) && MiscUtil.isZero((BigDecimal)taxInput.getAmount().getDecimal(), (boolean)false)) continue;
                TaxAbstraction tax = new TaxAbstraction();
                tax.setEquivalentAmount(taxInput.getAmount().getDecimal());
                tax.setCode(taxInput.getCode());
                result.add(tax);
            }
        }
        return result;
    }

    public static FareOverlay parseFareOverlay(PriceQuoteDetails pq) {
        if (pq.getMiscellaneousInfo() == null || pq.getMiscellaneousInfo().getTourNumber() == null || StringUtils.isBlank((String)pq.getMiscellaneousInfo().getTourNumber().getCode())) {
            return null;
        }
        if ("IT".equals(pq.getMiscellaneousInfo().getTourNumber().getCode())) {
            return FareOverlay.INCLUSIVE_TOUR;
        }
        throw Xeption.forDeveloper((String)"unexpected IT_BT_Fare value {0}", (Object[])new Object[]{pq.getMiscellaneousInfo().getTourNumber().getCode()});
    }

    public static String buildProductEndorsement(PriceQuoteDetails priceQuoteDetails, String pqEndorsement) {
        if (priceQuoteDetails.getMessageInfo() == null || priceQuoteDetails.getMessageInfo().getRemarkList() == null || priceQuoteDetails.getMessageInfo().getRemarkList().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (MessageEndorsementType endorsement : priceQuoteDetails.getMessageInfo().getRemarkList()) {
            if (!CodeEndorsementType.ENS.equals((Object)endorsement.getType())) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(endorsement.getString());
        }
        if (!StringUtils.isBlank((String)pqEndorsement)) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(pqEndorsement);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static List<AncillaryServicesPNRB> getAncillaryServices(GetReservationRSType response) {
        ArrayList<AncillaryServicesPNRB> result = new ArrayList<AncillaryServicesPNRB>();
        for (PassengerPNRB passenger : GetReservationHelper.getPassengers(response)) {
            if (passenger.getAncillaryServices() == null || passenger.getAncillaryServices().getAncillaryServiceList() == null) continue;
            result.addAll(passenger.getAncillaryServices().getAncillaryServiceList());
        }
        return result;
    }

    public static List<PassengerPNRB> getPassengers(GetReservationRSType response) {
        ReservationPNRB reservation = response.getReservation();
        ReservationChoiceGroup choice = reservation.getReservationChoiceGroup();
        PassengerReservationPNRB passengerReservation = choice.getPassengerReservation();
        PassengersPNRB passengers = passengerReservation.getPassengers();
        return passengers.getPassengerList();
    }

    public static LuggageInfo prepareLuggageInfo(SegmentBaggageInfo flightSegmentGetBaggage) {
        String baggageAllowanceType = flightSegmentGetBaggage.getAllowance().concat(MiscUtil.guarded((String)flightSegmentGetBaggage.getType()));
        if (baggageAllowanceType.startsWith(LUGGAGE_UNIT_NIL)) {
            baggageAllowanceType = LUGGAGE_UNIT_NIL;
        }
        return AirProductHelper.parseLuggageInfo((String)baggageAllowanceType);
    }

    public static String getCityCode(DictionaryReference<GeoLocation> locationRef) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
        if (location != null) {
            if (location.getType() == LocationType.CITY) {
                return SabreHelper.getNativeCode(locationRef);
            }
            if (location.getType() == LocationType.AIRPORT) {
                DictionaryReference parentLocationRef = location.getParent();
                return SabreHelper.getNativeCode((DictionaryReference)parentLocationRef);
            }
        }
        return null;
    }

    public static void updateSegmentFromItinSegment(Segment s, AirType itinSegment) {
        s.setStartDate(GetReservationHelper.getActualDepartureTime(itinSegment));
        DictionaryReference locationBegin = SabreHelper.resolveNativeCode(GeoLocation.class, (String)itinSegment.getDepartureAirport());
        s.setDepartureLocation(locationBegin);
        s.setDepartCityCode(GetReservationHelper.getCityCode((DictionaryReference<GeoLocation>)locationBegin));
        s.setDepartTerminal(itinSegment.getDepartureTerminalCode());
        s.setEndDate(GetReservationHelper.getActualArrivalTime(itinSegment));
        DictionaryReference locationEnd = SabreHelper.resolveNativeCode(GeoLocation.class, (String)itinSegment.getArrivalAirport());
        s.setArriveLocation(locationEnd);
        s.setArriveCityCode(GetReservationHelper.getCityCode((DictionaryReference<GeoLocation>)locationEnd));
        s.setArriveTerminal(itinSegment.getArrivalTerminalCode());
        s.setFlightNo(GetReservationHelper.getFlightNumber(itinSegment));
        s.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)itinSegment.getEquipmentType()));
        if (itinSegment.getElapsedTime() != null) {
            s.setFlightDuration(Integer.valueOf(GetReservationHelper.getTravelDuration(itinSegment.getElapsedTime())));
        }
        s.setFlightDistanceMiles(Integer.valueOf(itinSegment.getAirMilesFlown()));
    }

    static {
        IGNORED_PQ_STATUSES.add("H");
        IGNORED_PQ_STATUSES.add("U");
        P_PASSENGER_TYPE_NOT_APPLICABLE = Pattern.compile("(?<originalPtc>[A-Z0-9]{3}) NOT APPLICABLE - (?<usedPtc>[A-Z0-9]{3}) FARE USED - VERIFY RESTRICTIONS");
        P_DISCLOSURE_CARRIER_BANNER_AIRLINE = Pattern.compile("/(?<code>[A-Z0-9]{2}) .*");
    }

    public static class TaxAbstraction {
        private BigDecimal equivalentAmount;
        private String code;
        private Money baseAmount = null;

        public BigDecimal getEquivalentAmount() {
            return this.equivalentAmount;
        }

        public void setEquivalentAmount(BigDecimal value) {
            this.equivalentAmount = value;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String value) {
            this.code = value;
        }

        public Money getBaseAmount() {
            return this.baseAmount;
        }

        public void setBaseAmount(Money value) {
            this.baseAmount = value;
        }

        private BigDecimal getBaseAmountValue() {
            return this.baseAmount != null ? this.baseAmount.getValue() : null;
        }

        private String getBaseAmountCurrency() {
            return this.baseAmount != null ? this.baseAmount.getCurrency() : null;
        }

        public Tax toProductTax() {
            Tax result = new Tax();
            result.setEquivalentAmount(this.getEquivalentAmount());
            result.setCode(this.getCode());
            result.setAmount(this.baseAmount);
            return result;
        }

        public FlightTax toFlightTax() {
            FlightTax result = new FlightTax();
            result.setEquivalentAmount(this.getEquivalentAmount());
            result.setCode(this.getCode());
            result.setBaseAmount(this.baseAmount);
            return result;
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.getEquivalentAmount(), this.getCode(), this.getBaseAmountValue(), this.getBaseAmountCurrency()});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaxAbstraction)) {
                return false;
            }
            TaxAbstraction that = (TaxAbstraction)obj;
            if (!MiscUtil.equals((Object)this.getEquivalentAmount(), (Object)that.getEquivalentAmount())) {
                return false;
            }
            if (!MiscUtil.equals((Object)this.getCode(), (Object)that.getCode())) {
                return false;
            }
            if (!MiscUtil.equals((Object)this.getBaseAmountValue(), (Object)that.getBaseAmountValue())) {
                return false;
            }
            return MiscUtil.equals((Object)this.getBaseAmountCurrency(), (Object)that.getBaseAmountCurrency());
        }
    }
}

