/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;

public class GetReservationParseAncillariesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Date mcoTimelimit = null;
        for (PassengerPNRB passengerPNRB : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            if (passengerPNRB.getAncillaryServices() == null || passengerPNRB.getAncillaryServices().getAncillaryServiceList() == null) continue;
            for (AncillaryServicesPNRB as : passengerPNRB.getAncillaryServices().getAncillaryServiceList()) {
                if (as.getAncillaryServicesDataGroupPNRB().getPurchaseTimestamp() != null && (mcoTimelimit == null || as.getAncillaryServicesDataGroupPNRB().getPurchaseTimestamp().before(mcoTimelimit))) {
                    mcoTimelimit = as.getAncillaryServicesDataGroupPNRB().getPurchaseTimestamp();
                }
                if ("HK".equals(as.getAncillaryServicesDataGroupPNRB().getActionCode()) || "KK".equals(as.getAncillaryServicesDataGroupPNRB().getActionCode()) && as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO)) continue;
                Product product = GetReservationHelper.parseMcoProduct(as, reservation, passengerPNRB);
                reservation.getProducts().add(product);
            }
        }
        if (mcoTimelimit != null) {
            mcoTimelimit = new Date(mcoTimelimit.getTime() - (long)ZoneId.systemDefault().getRules().getOffset(Instant.now()).getTotalSeconds() * 1000L);
            ctx.putObject((Enum)IBusGdsSabreContextKeys.MCO_TIME_LIMIT, (Object)mcoTimelimit);
        }
    }
}

